package eu.dnetlib.data.mapreduce.hbase.dedup.preprocess;

import java.io.IOException;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class ExportFullnameReducer extends Reducer<ImmutableBytesWritable, Text, Text, Text> {

	private Text outValue;

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {

		outValue = new Text("");
	}

	@Override
	protected void reduce(final ImmutableBytesWritable key, final Iterable<Text> values, final Context context) throws IOException, InterruptedException {

		for (final Text fullname : values) {
			context.write(fullname, outValue);

		}
	}

}
