package eu.dnetlib.data.mapreduce.hbase.dedup.experiment;

import java.util.HashMap;
import java.util.Map.Entry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

/**
 * Created by claudio on 07/03/16.
 */
public class SubjectsMap extends HashMap<String, Subjects> {

	private static final Log log = LogFactory.getLog(SubjectsMap.class);

	public SubjectsMap mergeFrom(SubjectsMap sm) {

		if (sm != null) {
			for (Entry<String, Subjects> e : sm.entrySet()) {
				if (!this.containsKey(e.getKey())) {
					Subjects sub = new Subjects();

					sub.addAll(e.getValue());

					this.put(e.getKey(), sub);
				} else {
					for (String s : e.getValue()) {
						final Subjects subjects = this.get(e.getKey());
						subjects.add(s);
					}
				}
			}
		}

		return this;
	}

}
