package eu.dnetlib.data.mapreduce.hbase.dedup.experiment;

import java.util.Set;

import com.google.common.collect.Sets;
import com.google.gson.Gson;

/**
 * Created by claudio on 20/04/16.
 */
public class CsvEntry {

	private String key;

	private Set<String> features = Sets.newLinkedHashSet();

	private String title;

	private String id;

	private String originalName;

	public CsvEntry() {
	}

	public CsvEntry(final String key, final Set<String> features) {
		this.key = key;
		this.features = features;
	}

	public CsvEntry(final Set<String> features) {
		this.features = features;
	}

	public void addFeature(final String f) {
		getFeatures().add(f);
	}

	public Set<String> getFeatures() {
		return features;
	}

	public void setFeatures(final Set<String> features) {
		this.features = features;
	}

	public static CsvEntry fromJson(final String json) {
		return new Gson().fromJson(json, CsvEntry.class);
	}

	public String getKey() {
		return key;
	}

	public void setKey(final String key) {
		this.key = key;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

	@Override
	public boolean equals(final Object o) {
		return (o instanceof CsvEntry) && ((CsvEntry) o).getFeatures().equals(getFeatures());
	}

	public String getOriginalName() {
		return originalName;
	}

	public void setOriginalName(final String originalName) {
		this.originalName = originalName;
	}

}
