package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import java.io.IOException;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

/**
 * Created by claudio on 14/10/15.
 */
public class MindistSearchMapper extends Mapper<Text, VertexWritable, Text, VertexWritable> {

	@Override
	protected void map(Text key, VertexWritable value, Context context) throws IOException, InterruptedException {

		context.write(key, value);
		if (value.isActivated()) {
			VertexWritable writable = new VertexWritable();
			for (Text neighborVertex : value.getEdges()) {
				if (!neighborVertex.toString().equals(value.getVertexId().toString())) {
					writable.setVertexId(value.getVertexId());
					writable.setEdges(null);
					context.write(neighborVertex, writable);
				}
			}
		}
	}

}
