package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.collect.Iterables;
import eu.dnetlib.broker.objects.Journal;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Provenance;
import eu.dnetlib.broker.objects.Publication;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Instance;
import org.apache.commons.lang.math.RandomUtils;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.*;

/**
 * Created by claudio on 11/07/16.
 */
public class OpenAireEventPayloadFactory extends ProtoMapping {

	public static OpenAireEventPayload fromOAF(final OafEntity oaf, final OafEntity source, final float trust) {

		final Result.Metadata m = oaf.getResult().getMetadata();
		final Publication p = new Publication()
				.setOriginalId(getValue(oaf.getOriginalIdList()))
				.setTitles(listValues(m.getTitleList()))
				.setAbstracts(listValues(m.getDescriptionList()))
				.setLanguage(getKey(m.getLanguage()))
				.setSubjects(listValues(m.getSubjectList()))
				.setCreators(listValues(oaf.getResult().getAuthorList()))
				.setPublicationdate(getValue(m.getDateofacceptance()))
				.setPublisher(getValue(m.getPublisher()))
				.setEmbargoenddate(getValue(m.getEmbargoenddate()))
				.setContributor(listValues(m.getContributorList()))
				.setJournal(new Journal()
						.setName(m.getJournal().getName())
						.setIssn(m.getJournal().getIssnPrinted())
						.setEissn(m.getJournal().getIssnOnline())
						.setLissn(m.getJournal().getIssnLinking()))
				.setCollectedFrom(listValues(oaf.getCollectedfromList()))
				.setPids(mapPids(oaf.getPidList()))
				.setInstances(mapInstances(oaf.getResult().getInstanceList()))
				.setExternalReferences(mapExternalRefs(oaf.getResult().getExternalReferenceList()));

		final OpenAireEventPayload ep = new OpenAireEventPayload();
		final Instance instance = Iterables.getFirst(source.getResult().getInstanceList(), Instance.newBuilder().build());
		ep.setPublication(p)
			.setHighlight(new Publication())
			.setProvenance(new Provenance()
				.setRepositoryName(getValue(source.getCollectedfromList()))
				.setUrl(getValue(instance.getUrlList()))
				.setId(getValue(source.getOriginalIdList())))
				.setTrust(trust);

		return ep;
	}


}
