package eu.dnetlib.data.mapreduce.hbase.broker;

import java.io.IOException;

import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.FieldTypeProtos.StringField;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.ResultProtos.Result.Metadata;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer.Context;

import static eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory.asEvent;

/**
 * Created by claudio on 26/07/16.
 */
public class PublicationDateEventFactory {

	protected Text tKey = new Text("");

	public static void process(final Context context, final Oaf current, final Oaf other, final float trust) throws IOException, InterruptedException {
		new PublicationDateEventFactory().processPublicationDate(context, current, other, trust);
	}

	private void processPublicationDate(final Context context, final Oaf current, final Oaf other, final float trust) throws IOException, InterruptedException {
		if (hasPubDate(other)) {
			//doProcessPublicationDate(context, current, other, Topic.MORE_PUBLICATION_DATE);

			if (!hasPubDate(current)) {
				doProcessPublicationDate(context, current, other, Topic.MISSING_PUBLICATION_DATE, trust);
			}
		}
	}

	private void doProcessPublicationDate(final Context context, final Oaf current, final Oaf other, final Topic topic, final float trust) throws IOException, InterruptedException {
		final Oaf.Builder prototype = Oaf.newBuilder(current);

		final StringField date = other.getEntity().getResult().getMetadata().getDateofacceptance();
		prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().setDateofacceptance(date);

		final Oaf oaf = prototype.build();

		final EventMessage event = asEvent(oaf.getEntity(), topic, other.getEntity(), trust);
		final OpenAireEventPayload payload = OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust);
		event.setPayload(HighlightFactory.highlightEnrichPublicationDate(payload, date).toJSON());

		context.write(tKey, new Text(event.toString()));
		context.getCounter("event", topic.getValue()).increment(1);
	}

	private boolean hasPubDate(final Oaf current) {
		final Metadata m = current.getEntity().getResult().getMetadata();
		return StringUtils.isNotBlank(m.getDateofacceptance().getValue());
	}


}
