package eu.dnetlib.data.mapreduce.hbase.broker;

import java.io.IOException;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class CalculatePersonDistributionStep1Reducer extends Reducer<Text, Text, Text, Text> {

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		super.setup(context);
	}

	@Override
	protected void reduce(final Text key, final Iterable<Text> values, final Context context)
			throws IOException, InterruptedException {

		final String dsID = Bytes.toString(key.getBytes());

		int count = 0;

		String type = null;
		for (Text i : values) {
			final byte[] b = i.copyBytes();

			if (count == 0) {
				if (CalculatePersonDistributionUtils.isDsType(b)) {
					type = CalculatePersonDistributionUtils.getType(b);

					if (type.equals("pubsrepository::institutional")) {
						context.getCounter("REDUCER: Valid Datasource Typologies (all)", type).increment(1);
					} else {
						context.getCounter("REDUCER: Skipped Datasource Typologies", type).increment(1);
						return;
					}
				} else {
					System.err.println("Invalid record in iterable (expected dsType): " + Bytes.toString(b));
					context.getCounter("REDUCER: Invalid record in iterable", "expected dsType").increment(1);
					//context.getCounter("REDUCER: TEST 1", Bytes.toString(key.copyBytes())).increment(1);
					return;
				}
			} else {
				if (CalculatePersonDistributionUtils.isPerson(b)) {
					context.write(
							CalculatePersonDistributionUtils.prepareHdfsKey(dsID, count),
							CalculatePersonDistributionUtils.prepareHdfsValue(dsID, CalculatePersonDistributionUtils.getPersonName(b)));
				} else {
					System.err.println("Invalid record in iterable (expected person): " + Bytes.toString(b));
					context.getCounter("REDUCER: Invalid record in iterable", "expected person").increment(1);
					return;
				}
				if (count == 1) {
					context.getCounter("REDUCER: Valid Datasource Typologies (with persons)", type).increment(1);
				}
			}
			count++;
		}

		if (type != null && count > 0) {
			context.getCounter("REDUCER: Person occurrences", type).increment(count - 1);
		}
	}
}