package eu.dnetlib.data.mapreduce.hbase.dedup.preprocess;

import java.io.IOException;

import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.TypeProtos.Type;

/**
 * builds map {merged author -> anchorId}
 *
 * @author claudio
 *
 */
public class ExportFullnameMapper extends TableMapper<ImmutableBytesWritable, Text> {

	private ImmutableBytesWritable outKey;

	private Text outValue;

	@Override
	protected void setup(final Context context) {
		outKey = new ImmutableBytesWritable(Bytes.toBytes("1"));
		outValue = new Text();
	}

	@Override
	protected void map(final ImmutableBytesWritable rowkey, final Result value, final Context context) throws IOException, InterruptedException {

		final OafRowKeyDecoder rkd = OafRowKeyDecoder.decode(rowkey.copyBytes());

		if (!Type.person.equals(rkd.getType())) {
			context.getCounter(rkd.getType().toString(), "skipped").increment(1);
		}

		final byte[] body = value.getValue(Bytes.toBytes(Type.person.toString()), DedupUtils.BODY_B);

		final OafDecoder d = OafDecoder.decode(body);

		final String fullname = d.getEntity().getPerson().getMetadata().getFullname().getValue();

		outValue.set(fullname);

		context.write(outKey, outValue);
	}

}
