package eu.dnetlib.data.mapreduce.hbase.dataexport;

import java.io.IOException;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;

import com.google.common.base.Joiner;
import com.googlecode.protobuf.format.JsonFormat;

import eu.dnetlib.data.mapreduce.util.OafDecoder;

/**
 * Exports Oaf objects as their json serialization.
 *
 * @author claudio
 *
 */
public class ExportInformationSpaceMapper extends TableMapper<Text, Text> {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(ExportInformationSpaceMapper.class); // NOPMD by marko on 11/24/08 5:02 PM

	private static final String SEPARATOR = "@";

	private Text keyOut;

	private Text valueOut;

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		super.setup(context);

		keyOut = new Text();
		valueOut = new Text();
	}

	@Override
	protected void map(final ImmutableBytesWritable keyIn, final Result value, final Context context) throws IOException, InterruptedException {
		try {
			byte[] rowKey = keyIn.copyBytes();
			Map<byte[], NavigableMap<byte[], byte[]>> row = value.getNoVersionMap();

			for (byte[] cf : row.keySet()) {

				for (Entry<byte[], byte[]> q : row.get(cf).entrySet()) {

					emit(rowKey, cf, q.getKey(), q.getValue(), context);
				}
			}
		} catch (final Throwable e) {
			log.error("error exporting the following record from HBase: " + value.toString(), e);
			context.getCounter("error", e.getClass().getName()).increment(1);
			throw new RuntimeException(e);
		}
	}

	private void emit(final byte[] rowKey, final byte[] cf, final byte[] q, final byte[] value, final Context context) throws IOException, InterruptedException {

		keyOut.set(Joiner.on(SEPARATOR).join(new String(rowKey), new String(cf), new String(q)));

		if ((value == null) || (value.length == 0)) {
			valueOut.set("");
		} else {
			valueOut.set(new JsonFormat().printToString(OafDecoder.decode(value).getOaf()));
		}
		context.write(keyOut, valueOut);
	}

}
