package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.broker.model.openaire.ExternalReference;
import eu.dnetlib.data.broker.model.openaire.Instance;
import eu.dnetlib.data.broker.model.openaire.Pid;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.ResultProtos.Result;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getKey;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getValue;

/**
 * Created by claudio on 22/07/16.
 */
public abstract class ProtoMapping {

	protected static List<Instance> mapInstances(final List<Result.Instance> in) {
		return Lists.newArrayList(Iterables.transform(in, new Function<Result.Instance, Instance>() {
					@Override
					public Instance apply(final Result.Instance i) {
						return new Instance()
								.setHostedby(getValue(i.getHostedby()))
								.setInstancetype(getValue(i.getInstancetype()))
								.setLicense(getKey(i.getLicence()))
								.setUrl(Iterables.getFirst(i.getUrlList(), ""));
					}
				}));
	}

	protected static List<Pid> mapPids(final List<StructuredProperty> sp) {
		return Lists.newArrayList(Iterables.transform(sp, new Function<StructuredProperty, Pid>() {
					@Override
					public Pid apply(final StructuredProperty sp) {
						return new Pid().setType(sp.getQualifier().getClassid()).setValue(sp.getValue());
					}
				}));
	}

	protected static List<ExternalReference> mapExternalRefs(final List<Result.ExternalReference> ext) {
		return Lists.newArrayList(Iterables.transform(ext, new Function<Result.ExternalReference, ExternalReference>() {
					@Override
					public ExternalReference apply(final Result.ExternalReference e) {
						return new ExternalReference()
								.setUrl(e.getUrl())
								.setType(getKey(e.getQualifier()))
								.setRefidentifier(e.getRefidentifier())
								.setSitename(e.getSitename());
					}
				}));
	}

}
