package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import eu.dnetlib.data.broker.model.openaire.Journal;
import eu.dnetlib.data.broker.model.openaire.OpenAireEventPayload;
import eu.dnetlib.data.broker.model.openaire.Publication;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.*;

/**
 * Created by claudio on 11/07/16.
 */
public class OpenAireEventPayloadFactory extends ProtoMapping {

	public static OpenAireEventPayload fromOAF(final OafEntity oaf) {

		final Result.Metadata m = oaf.getResult().getMetadata();
		final Publication p = new Publication()
				.setTitles(getValues(m.getTitleList()))
				.setAbstracts(getValues(m.getDescriptionList()))
				.setLanguage(getKey(m.getLanguage()))
				.setSubjects(getValues(m.getSubjectList()))
				.setCreators(getValues(oaf.getResult().getAuthorList()))
				.setPublicationdate(getValue(m.getDateofacceptance()))
				.setPublisher(getValue(m.getPublisher()))
				.setEmbargoenddate(getValue(m.getEmbargoenddate()))
				.setContributor(getValues(m.getContributorList()))
				.setJournal(new Journal()
						.setName(m.getJournal().getName())
						.setIssn(m.getJournal().getIssnPrinted())
						.setEissn(m.getJournal().getIssnOnline())
						.setLissn(m.getJournal().getIssnLinking()))
				.setCollectedFrom(getValues(oaf.getCollectedfromList()))
				.setPids(mapPids(oaf.getPidList()))
				.setInstances(mapInstances(oaf.getResult().getInstanceList()))
				.setExternalReferences(mapExternalRefs(oaf.getResult().getExternalReferenceList()));

		final OpenAireEventPayload ep = new OpenAireEventPayload();
		ep.setPublication(p).setHighlight(new Publication());

		return ep;
	}


}
