package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.broker.model.openaire.OpenAireEventPayload;
import eu.dnetlib.data.proto.FieldTypeProtos.StringField;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ProjectProtos.Project;
import eu.dnetlib.data.proto.ProjectProtos.Project.Metadata;
import eu.dnetlib.data.proto.ResultProtos.Result.Instance;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getValue;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getValues;

/**
 * Created by alessia on 21/07/16.
 */
public class HighlightFactory extends ProtoMapping {

	public static OpenAireEventPayload highlightEnrichOa(final OpenAireEventPayload p, List<Instance> instances) {
		p.getHighlight().setInstances(mapInstances(instances));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichPid(final OpenAireEventPayload p, final List<StructuredProperty> pids) {
		p.getHighlight().setPids(mapPids(pids));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichPublicationDate(final OpenAireEventPayload p, final StringField date) {
		p.getHighlight().setPublicationdate(getValue(date));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichAbstract(final OpenAireEventPayload p, List<StringField> descriptionList){
		p.getHighlight().setAbstracts(getValues(descriptionList));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichSubject(final OpenAireEventPayload p, final List<StructuredProperty> subjects){
		p.getHighlight().setSubjects(getValues(subjects));
		return p;
	}

	//TODO: highlight for the following reasons
	public static OpenAireEventPayload highlightEnrichProject(final OpenAireEventPayload p, final OafEntity projectEntity, boolean inferredLink){
		//TODO: this can wait. Think about generating the openaire string for project links: it will be easier for subscribers to integrate it back to their records!
		Project project = projectEntity.getProject();
		Metadata projectMetadata = project.getMetadata();
		StringField acro = projectMetadata.getAcronym();
		StringField title = projectMetadata.getTitle();
		StringField code = projectMetadata.getCode();
		List<StringField> fundingtree = projectMetadata.getFundingtreeList();
		String fundingTrees = "<fundings>"+Joiner.on(" ").join(Iterables.transform(fundingtree, new Function<StringField, String>() {
			@Override
			public String apply(final StringField v) {
				return v.getValue();
			}
		}

		)) + "</fundings>";
		return p;
	}


	public static OpenAireEventPayload highlightEnrichDataset(final OpenAireEventPayload p){
		//TODO: this can wait
		return p;
	}

	public static OpenAireEventPayload highlightEnrichAuthorPid(final OpenAireEventPayload p){
		//TODO: this can wait
		return p;
	}

	// Commenting highlights for addition events: the record is new for the subscriber!
	/*public static OpenAireEventPayload highlightAddByAffiliation(final OpenAireEventPayload p){
		return p;
	}

	public static OpenAireEventPayload highlightAddByReference(final OpenAireEventPayload p){
		return p;
	}

	public static OpenAireEventPayload highlightAddByProject(final OpenAireEventPayload p){
		//TODO: this cannot wait
		return p;
	}*/



}
