package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.*;

import java.util.Map;

import com.google.common.collect.Maps;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import org.apache.commons.lang.StringUtils;

/**
 * Created by claudio on 20/07/16.
 */
public class EventFactory {

	private final static String PRODUCER_ID = "OpenAIRE";

	public static EventMessage asEvent(final OafEntity oaf, final Topic topic, final OafEntity source) {
		return asEvent(
				oaf,
				topic,
				getKey(source.getCollectedfromList()),
				getValue(source.getCollectedfromList()),
				getValue(source.getOriginalIdList()));
	}

	public static EventMessage asEvent(final OafEntity oaf, final Topic topic, final String sourceDatasourceId, final String sourceDatasourceName) {
		return asEvent(oaf, topic, sourceDatasourceId, sourceDatasourceName, null);
	}

	public static EventMessage asEvent(final OafEntity oaf, final Topic topic, final String sourceDatasourceId, final String sourceDatasourceName, final String sourceOriginalIds) {
		final Map<String, String> map = Maps.newHashMap();

		//TARGET INFO
		final String targetDatasourceId = getKey(oaf.getCollectedfromList());
		if (StringUtils.isNotBlank(targetDatasourceId)) {
			map.put("target_datasource_id", targetDatasourceId);
		}

		final String targetDatasourceName = getValue(oaf.getCollectedfromList());
		if (StringUtils.isNotBlank(targetDatasourceName)) {
			map.put("target_datasource_name", targetDatasourceName);
		}

		final String title = getValue(oaf.getResult().getMetadata().getTitleList());
		if (StringUtils.isNotBlank(title)) {
			map.put("target_publication_title", title);
		}

		map.put("target_publication_id", getValue(oaf.getOriginalIdList()));
		map.put("trust", "1");

		//PROVENANCE INFO
		if (StringUtils.isNotBlank(sourceDatasourceName)) {
			map.put("provenance_datasource_name", sourceDatasourceName);
		}

		if (StringUtils.isNotBlank(sourceDatasourceId)) {
			map.put("provenance_datasource_id", sourceDatasourceId);
		}

		if (StringUtils.isNotBlank(sourceOriginalIds)) {
			map.put("provenance_publication_id_csv", sourceOriginalIds);
		}

		//final OpenAireEventPayload p = new OpenAireEventPayload(oaf.getEntity().getId());

		return new EventMessage(PRODUCER_ID, topic, EventMessage.TTH_INFINITE, map);
	}

}
