/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.transform.OafUtils;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class OafHbaseUtils
extends OafUtils {
    public static OafDecoder decode(ImmutableBytesWritable oaf) {
        return new OafDecoder(oaf.copyBytes());
    }

    public static Function<ImmutableBytesWritable, OafDecoder> decoder() {
        return new Function<ImmutableBytesWritable, OafDecoder>(){

            public OafDecoder apply(ImmutableBytesWritable input) {
                return OafDecoder.decode((byte[])input.copyBytes());
            }
        };
    }

    public static Iterable<OafProtos.Oaf> asOaf(Iterable<ImmutableBytesWritable> in) {
        return Iterables.transform(in, OafHbaseUtils.oafDecoder());
    }

    public static Function<ImmutableBytesWritable, OafProtos.Oaf> oafDecoder() {
        return new Function<ImmutableBytesWritable, OafProtos.Oaf>(){

            public OafProtos.Oaf apply(ImmutableBytesWritable input) {
                return OafHbaseUtils.parse(input);
            }
        };
    }

    public static OafProtos.Oaf parse(ImmutableBytesWritable input) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])input.copyBytes());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> String getValue(T t) {
        return OafHbaseUtils.mapValue(t);
    }

    public static <T> String getKey(T t) {
        return OafHbaseUtils.mapKey(t);
    }

    public static <T> String getValue(Iterable<T> ts) {
        return (String)Iterables.getFirst(OafHbaseUtils.getValues(ts), (Object)"");
    }

    public static <T> List<String> getValues(Iterable<T> ts) {
        return Lists.newArrayList((Iterable)Iterables.transform(ts, (Function)new Function<T, String>(){

            public String apply(T t) {
                return OafHbaseUtils.mapValue(t);
            }
        }));
    }

    public static <T> String getKey(Iterable<T> ts) {
        return (String)Iterables.getFirst(OafHbaseUtils.getKeys(ts), (Object)"");
    }

    public static <T> List<String> getKeys(Iterable<T> ts) {
        return Lists.newArrayList((Iterable)Iterables.transform(ts, (Function)new Function<T, String>(){

            public String apply(T t) {
                return OafHbaseUtils.mapKey(t);
            }
        }));
    }

    private static <T> String mapKey(T t) {
        if (t instanceof FieldTypeProtos.KeyValue) {
            return ((FieldTypeProtos.KeyValue)t).getKey();
        }
        if (t instanceof String) {
            return (String)t;
        }
        if (t instanceof FieldTypeProtos.Qualifier) {
            return ((FieldTypeProtos.Qualifier)t).getClassid();
        }
        throw new IllegalArgumentException(String.format("type %s not mapped", t.getClass()));
    }

    private static <T> String mapValue(T t) {
        if (t instanceof FieldTypeProtos.StructuredProperty) {
            return ((FieldTypeProtos.StructuredProperty)t).getValue();
        }
        if (t instanceof FieldTypeProtos.KeyValue) {
            return ((FieldTypeProtos.KeyValue)t).getValue();
        }
        if (t instanceof String) {
            return (String)t;
        }
        if (t instanceof PersonProtos.Person) {
            return ((PersonProtos.Person)t).getMetadata().getFullname().getValue();
        }
        if (t instanceof FieldTypeProtos.StringField) {
            return ((FieldTypeProtos.StringField)t).getValue();
        }
        if (t instanceof FieldTypeProtos.Qualifier) {
            return ((FieldTypeProtos.Qualifier)t).getClassname();
        }
        throw new IllegalArgumentException(String.format("type %s not mapped", t.getClass()));
    }

    public static List<String> getPropertyValues(Reducer.Context context, String name) {
        return OafHbaseUtils.doGetPropertyValues(context.getConfiguration().get(name, ""));
    }

    public static List<String> getPropertyValues(Mapper.Context context, String name) {
        return OafHbaseUtils.doGetPropertyValues(context.getConfiguration().get(name, ""));
    }

    private static List<String> doGetPropertyValues(String s) {
        return Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)s));
    }
}

