/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.experiment;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.hbase.dedup.experiment.CsvEntry;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class CsvSerialiser {
    private static final int MAX_FEATURES = 1000;
    private static final int MAX_ROWS = 5000;
    private int maxRows = 5000;
    private int maxFeatures = 1000;

    public CsvSerialiser() {
    }

    public CsvSerialiser(int maxRows, int maxFeatures) {
        this.maxRows = maxRows;
        this.maxFeatures = maxFeatures;
    }

    public String asCSV(List<CsvEntry> list) {
        LinkedHashSet features = Sets.newLinkedHashSet();
        for (CsvEntry e : Iterables.limit(list, (int)this.maxRows)) {
            features.addAll(e.getFeatures());
        }
        LinkedList cappedFeatures = Lists.newLinkedList((Iterable)Iterables.limit((Iterable)features, (int)this.maxFeatures));
        StringWriter csv = new StringWriter();
        csv.append("\"k\",");
        csv.append(Joiner.on((String)",").join((Iterable)cappedFeatures));
        csv.append(",\"id\",\"name\",\"title\"\n");
        for (CsvEntry e : Iterables.limit(list, (int)this.maxRows)) {
            boolean hasZero = false;
            boolean hasOne = false;
            StringWriter line = new StringWriter();
            line.append(e.getKey() + ",");
            for (String f : cappedFeatures) {
                if (e.getFeatures().contains(f)) {
                    line.append("1,");
                    hasOne = true;
                    continue;
                }
                line.append("0,");
                hasZero = true;
            }
            line.append("\"" + e.getId() + "\",");
            line.append("\"" + e.getOriginalName() + "\",");
            line.append("\"" + e.getTitle() + "\"");
            if (!hasZero || !hasOne) continue;
            csv.append(line.toString() + "\n");
        }
        return csv.toString();
    }
}

