/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.experiment;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.PersonProtos;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class AnchorStatsMapper
extends TableMapper<NullWritable, NullWritable> {
    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        byte[] body = value.getValue("person".getBytes(), DedupUtils.BODY_B);
        if (body != null) {
            try {
                OafDecoder decoder = OafDecoder.decode((byte[])body);
                PersonProtos.Person p = decoder.getEntity().getPerson();
                if (!p.getAnchor()) {
                    context.getCounter("person", "not anchor").increment(1L);
                    return;
                }
                this.trackPersonInfo(p.getMergedpersonCount(), context, "person merged");
                this.trackPersonInfo(p.getCoauthorCount(), context, "person coauthors");
            }
            catch (Throwable e) {
                System.out.println("GOT EX " + e);
                context.getCounter("error", e.getClass().toString()).increment(1L);
            }
        } else {
            context.getCounter("person", "missing body").increment(1L);
        }
    }

    private void trackPersonInfo(int count, Mapper.Context context, String counterName) {
        if (count > 0 && count <= 10) {
            context.getCounter(counterName, count + "").increment(1L);
            return;
        }
        if (count > 10 && count <= 20) {
            context.getCounter(counterName, "[10, 20)").increment(1L);
            return;
        }
        if (count > 20 && count <= 30) {
            context.getCounter(counterName, "[20, 30)").increment(1L);
            return;
        }
        if (count > 30 && count <= 40) {
            context.getCounter(counterName, "[30, 40)").increment(1L);
            return;
        }
        if (count > 40 && count <= 50) {
            context.getCounter(counterName, "[40, 50)").increment(1L);
            return;
        }
        if (count > 50 && count <= 70) {
            context.getCounter(counterName, "[50, 70)").increment(1L);
            return;
        }
        if (count > 70 && count <= 100) {
            context.getCounter(counterName, "[70, 100)").increment(1L);
            return;
        }
        if (count > 100) {
            context.getCounter(counterName, "[100, *)").increment(1L);
            return;
        }
    }
}

