/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupDeleteRelMapper
extends TableMapper<ImmutableBytesWritable, Writable> {
    private DedupConfig dedupConf;
    private ImmutableBytesWritable outKey;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.outKey = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
        this.deleteRels(rowkey, context, value, DedupUtils.getSimilarityCFBytes(type));
        this.deleteRels(rowkey, context, value, DedupUtils.getDedupCF_mergedInBytes(type));
        this.deleteRels(rowkey, context, value, DedupUtils.getDedupCF_mergesBytes(type));
    }

    private void deleteRels(ImmutableBytesWritable rowkey, Mapper.Context context, Result value, byte[] cf) throws IOException, InterruptedException {
        NavigableMap rels = value.getFamilyMap(cf);
        if (rels != null && !rels.isEmpty()) {
            byte[] row = rowkey.copyBytes();
            Delete delete = new Delete(row);
            delete.setWriteToWAL(true);
            delete.deleteFamily(cf);
            this.outKey.set(row);
            context.write((Object)this.outKey, (Object)delete);
            context.getCounter(this.dedupConf.getWf().getEntityType(), new String(cf) + " deleted").increment((long)rels.size());
        }
    }
}

