/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.broker.model.openaire.ExternalReference;
import eu.dnetlib.data.broker.model.openaire.Instance;
import eu.dnetlib.data.broker.model.openaire.Pid;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.util.List;

public abstract class ProtoMapping {
    protected static List<Instance> mapInstances(List<ResultProtos.Result.Instance> in) {
        return Lists.newArrayList((Iterable)Iterables.transform(in, (Function)new Function<ResultProtos.Result.Instance, Instance>(){

            public Instance apply(ResultProtos.Result.Instance i) {
                return new Instance().setHostedby(OafHbaseUtils.getValue(i.getHostedby())).setInstancetype(OafHbaseUtils.getValue(i.getInstancetype())).setLicense(OafHbaseUtils.getKey(i.getLicence())).setUrl((String)Iterables.getFirst((Iterable)i.getUrlList(), (Object)""));
            }
        }));
    }

    protected static List<Pid> mapPids(List<FieldTypeProtos.StructuredProperty> sp) {
        return Lists.newArrayList((Iterable)Iterables.transform(sp, (Function)new Function<FieldTypeProtos.StructuredProperty, Pid>(){

            public Pid apply(FieldTypeProtos.StructuredProperty sp) {
                return new Pid().setType(sp.getQualifier().getClassid()).setValue(sp.getValue());
            }
        }));
    }

    protected static List<ExternalReference> mapExternalRefs(List<ResultProtos.Result.ExternalReference> ext) {
        return Lists.newArrayList((Iterable)Iterables.transform(ext, (Function)new Function<ResultProtos.Result.ExternalReference, ExternalReference>(){

            public ExternalReference apply(ResultProtos.Result.ExternalReference e) {
                return new ExternalReference().setUrl(e.getUrl()).setType(OafHbaseUtils.getKey(e.getQualifier())).setRefidentifier(e.getRefidentifier()).setSitename(e.getSitename());
            }
        }));
    }
}

