/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.collect.Maps;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class EventFactory {
    private static final String PRODUCER_ID = "OpenAIRE";

    public static EventMessage asEvent(OafProtos.OafEntity oaf, Topic topic, OafProtos.OafEntity source) {
        return EventFactory.asEvent(oaf, topic, OafHbaseUtils.getKey(source.getCollectedfromList()), OafHbaseUtils.getValue(source.getCollectedfromList()), OafHbaseUtils.getValue(source.getOriginalIdList()));
    }

    public static EventMessage asEvent(OafProtos.OafEntity oaf, Topic topic, String sourceDatasourceId, String sourceDatasourceName) {
        return EventFactory.asEvent(oaf, topic, sourceDatasourceId, sourceDatasourceName, null);
    }

    public static EventMessage asEvent(OafProtos.OafEntity oaf, Topic topic, String sourceDatasourceId, String sourceDatasourceName, String sourceOriginalIds) {
        String title;
        String targetDatasourceName;
        HashMap map = Maps.newHashMap();
        String targetDatasourceId = OafHbaseUtils.getKey(oaf.getCollectedfromList());
        if (StringUtils.isNotBlank((String)targetDatasourceId)) {
            map.put("target_datasource_id", targetDatasourceId);
        }
        if (StringUtils.isNotBlank((String)(targetDatasourceName = OafHbaseUtils.getValue(oaf.getCollectedfromList())))) {
            map.put("target_datasource_name", targetDatasourceName);
        }
        if (StringUtils.isNotBlank((String)(title = OafHbaseUtils.getValue(oaf.getResult().getMetadata().getTitleList())))) {
            map.put("target_publication_title", title);
        }
        map.put("target_publication_id", OafHbaseUtils.getValue(oaf.getOriginalIdList()));
        map.put("trust", "1");
        if (StringUtils.isNotBlank((String)sourceDatasourceName)) {
            map.put("provenance_datasource_name", sourceDatasourceName);
        }
        if (StringUtils.isNotBlank((String)sourceDatasourceId)) {
            map.put("provenance_datasource_id", sourceDatasourceId);
        }
        if (StringUtils.isNotBlank((String)sourceOriginalIds)) {
            map.put("provenance_publication_id_csv", sourceOriginalIds);
        }
        return new EventMessage(PRODUCER_ID, topic, -1, map);
    }
}

