/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.es;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class ElasticsearchFeedMapper
extends TableMapper<NullWritable, BytesWritable> {
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes());
        OafProtos.Oaf oaf = this.mergeUpdates(value, context, keyDecoder.getType(), keyDecoder);
        if (this.isValid(oaf)) {
            new JsonFormat();
            context.write((Object)NullWritable.get(), (Object)new BytesWritable(Bytes.toBytes((String)JsonFormat.printToString((Message)oaf))));
        }
    }

    private OafProtos.Oaf mergeUpdates(Result value, Mapper.Context context, TypeProtos.Type type, OafRowKeyDecoder keyDecoder) throws InvalidProtocolBufferException {
        try {
            return UpdateMerger.mergeBodyUpdates(context, value.getFamilyMap(Bytes.toBytes((String)type.toString())));
        }
        catch (InvalidProtocolBufferException e) {
            System.err.println(String.format("Unable to parse proto (Type: %s) in row: %s", type.toString(), keyDecoder.getKey()));
            throw e;
        }
    }

    private boolean isValid(OafProtos.Oaf oaf) {
        return oaf != null && oaf.isInitialized();
    }
}

