package eu.dnetlib.functionality.index.query;

import org.apache.solr.client.solrj.response.QueryResponse;

import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.utils.MetadataReference;

/**
 * The Class SolrIndexQueryResponseFactory.
 */
public class SolrIndexQueryResponseFactory extends QueryResponseFactory<QueryResponse> {

	/**
	 * {@inheritDoc}
	 * 
	 * @throws IndexClientException
	 *
	 * @see eu.dnetlib.functionality.index.query.QueryResponseFactory#getQueryResponseParser(eu.dnetlib.functionality.index.query.IndexQueryResponse,
	 *      eu.dnetlib.functionality.index.utils.MetadataReference)
	 */
	@Override
	public QueryResponseParser getQueryResponseParser(final IndexQueryResponse<QueryResponse> queryRsp, final MetadataReference mdRef)
			throws IndexClientException {

		QueryResponse response = queryRsp.getContextualQueryResponse();
		return new SolrResponseParser(highlightUtils, browseAliases.get(mdRef), returnEmptyFields, includeRanking, response);
	}

}
