/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.hdfs.SequenceFileWriterFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SequenceFileFeeder {
    private static final Log log = LogFactory.getLog(SequenceFileFeeder.class);
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;
    @Autowired
    protected SequenceFileWriterFactory sequenceFileWriterFactory;

    public int feed(String epr, ClusterName clusterName, String path) throws IOException {
        return this.doWrite(epr, clusterName, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWrite(String epr, ClusterName clusterName, String path) throws IOException {
        log.info((Object)("Opened sequence file writer: " + writer.toString()));
        try (SequenceFile.Writer writer = this.sequenceFileWriterFactory.getSequenceFileWriter(Text.class, Text.class, this.getConf(clusterName), new Path(path));){
            Text idText = new Text();
            Text bodyText = new Text();
            int count = 0;
            int nulls = 0;
            for (String record : this.getResultSetClientFactory().getClient(epr)) {
                if (StringUtils.isBlank((String)record)) {
                    ++nulls;
                    continue;
                }
                idText.set(String.valueOf(count++));
                bodyText.set(record);
                writer.append((Writable)idText, (Writable)bodyText);
            }
            log.info((Object)("written " + count + " records in sequence file: " + path));
            if (nulls > 0) {
                log.warn((Object)("found " + nulls + " records in epr!"));
            }
            int n = count;
            return n;
        }
    }

    protected Configuration getConf(ClusterName clusterName) {
        return this.configurationEnumerator.get(clusterName);
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

