/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import eu.dnetlib.data.transform.XsltRowTransformerFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class HbaseTableFeeder {
    private static final Log log = LogFactory.getLog(HbaseTableFeeder.class);
    private int batchSize = 100;
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;

    public int feed(String epr, String xsl, ClusterName clusterName, String tableName, boolean simulation) throws IOException {
        return this.doWrite(this.asRows(epr, xsl), this.getConf(clusterName), tableName, simulation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWrite(Iterable<Row> rows, Configuration configuration, String tableName, boolean simulation) throws IOException {
        ArrayList buffer = Lists.newArrayList();
        int count = 0;
        if (simulation) {
            log.info((Object)"running in simulation mode ...");
            log.info((Object)String.format("... simulated import of %d records", Iterables.size(rows)));
        } else {
            HTable htable = new HTable(configuration, tableName);
            try {
                int i = 0;
                for (Row row : rows) {
                    Put put = new Put(Bytes.toBytes((String)row.getKey()));
                    put.setWriteToWAL(false);
                    for (Column col : row) {
                        put.add(Bytes.toBytes((String)row.getColumnFamily()), Bytes.toBytes((String)((String)col.getName())), (byte[])col.getValue());
                    }
                    buffer.add(put);
                    if (++i % this.getBatchSize() != 0) continue;
                    htable.put((List)buffer);
                    count += buffer.size();
                    buffer.clear();
                }
            }
            finally {
                if (!buffer.isEmpty()) {
                    htable.put((List)buffer);
                    count += buffer.size();
                }
                htable.flushCommits();
                htable.close();
            }
        }
        return count;
    }

    protected Iterable<Row> asRows(String epr, String xsl) {
        return Iterables.concat((Iterable)Iterables.transform((Iterable)this.getResultSetClientFactory().getClient(epr), (Function)XsltRowTransformerFactory.newInstance((String)xsl)));
    }

    protected Configuration getConf(ClusterName clusterName) {
        return this.configurationEnumerator.get(clusterName);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

