/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import eu.dnetlib.data.hadoop.action.AbstractHadoopAction;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DeleteHdfsPathAction
extends AbstractHadoopAction {
    private static final Log log = LogFactory.getLog(DeleteHdfsPathAction.class);

    @Override
    protected void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws HadoopServiceException {
        try {
            ClusterName clusterName = ClusterName.valueOf((String)((String)job.getParameters().get("cluster")));
            log.info((Object)("delete request on cluster: " + clusterName.toString()));
            this.delete((String)job.getParameters().get("path"), this.configurationEnumerator.get(clusterName));
            handler.done(job);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    private void delete(String path, Configuration conf) throws IOException {
        Path absolutePath;
        if (StringUtils.isBlank((String)path)) {
            throw new IOException("Cannot delete an empty HDFS path.");
        }
        FileSystem hdfs = FileSystem.get((Configuration)conf);
        if (hdfs.exists(absolutePath = new Path(URI.create(conf.get("fs.defaultFS") + path)))) {
            log.debug((Object)("delete path: " + absolutePath.toString()));
            hdfs.delete(absolutePath, true);
            log.info((Object)("deleted path: " + absolutePath.toString()));
        } else {
            log.warn((Object)("cannot delete unexisting path: " + absolutePath.toString()));
        }
    }
}

