/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltRowTransformer
implements Function<String, List<Row>> {
    private static final Log log = LogFactory.getLog(XsltRowTransformer.class);
    private Transformer transformer;
    private SAXReader reader = new SAXReader();

    public XsltRowTransformer(Transformer transformer) {
        this.transformer = transformer;
        log.info((Object)String.format("using trasformer: '%s'", this.getTransformerClassName()));
    }

    private Document transform(Document doc) {
        if (this.transformer == null) {
            return doc;
        }
        DocumentResult result = new DocumentResult();
        try {
            this.transformer.transform((Source)new DocumentSource(doc), (Result)result);
            return result.getDocument();
        }
        catch (TransformerException e) {
            throw new RuntimeException("Unable to transform document:\n" + doc.asXML(), e);
        }
    }

    private Document transform(String xml) {
        try {
            return this.transform(this.reader.read((Reader)new StringReader(xml)));
        }
        catch (DocumentException e) {
            log.error((Object)("Error parsing xml:\n" + xml), (Throwable)e);
            throw new RuntimeException("Unable to parse document:\n" + xml, e);
        }
    }

    private List<Row> transformAsListRow(String xml) {
        Document doc = this.transform(xml);
        ArrayList rows = Lists.newArrayList();
        if (doc == null) {
            return rows;
        }
        for (Object or : doc.selectNodes("//ROW")) {
            Element row = (Element)or;
            String columnFamily = row.valueOf("@columnFamily");
            String key = row.valueOf("@key");
            if (key == null || key.isEmpty()) {
                throw new RuntimeException("Attribute 'key' is missing in XSLT");
            }
            if (columnFamily == null || columnFamily.isEmpty()) {
                throw new RuntimeException("Attribute 'columnFamily' is missing in XSLT");
            }
            ArrayList cols = Lists.newArrayList();
            for (Object of : row.selectNodes("./QUALIFIER")) {
                Node node = (Node)of;
                String name = node.valueOf("@name");
                String type = node.valueOf("@type");
                byte[] value = this.decode(node.getText().trim(), type);
                cols.add(new Column<String, byte[]>(name, value));
            }
            rows.add(new Row(columnFamily, key, cols));
        }
        return rows;
    }

    public String getTransformerClassName() {
        return this.transformer != null ? this.transformer.getClass().getName() : "null";
    }

    private byte[] decode(String value, String type) {
        if ("base64".equals(type)) {
            return Base64.decodeBase64((String)value);
        }
        return value.getBytes();
    }

    public List<Row> apply(String xml) {
        return this.transformAsListRow(xml);
    }
}

