package eu.dnetlib.data.hadoop.hdfs;

import java.io.IOException;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.SequenceFile.CompressionType;
import org.apache.hadoop.io.SequenceFile.Writer.Option;
import org.apache.hadoop.io.Writable;
import org.springframework.beans.factory.annotation.Required;

/**
 * Factory for SequenceFile.Writer instances
 * 
 * @author claudio
 *
 */
public class SequenceFileWriterFactory {

	private Class<? extends Writable> keyClass;

	private Class<? extends Writable> valueClass;

	private String compressionType;

	private String blockSize = "64M";

	public SequenceFile.Writer getSequenceFileWriter(
			final Class<? extends Writable> keyClass,
			final Class<? extends Writable> valueClass,
			final Configuration conf,
			final Path sequenceFilePath) throws IOException {

		Configuration newConf = new Configuration(conf);
		newConf.set("dfs.blocksize", getBlockSize());

		Option oFile = SequenceFile.Writer.file(sequenceFilePath);
		Option oKey = SequenceFile.Writer.keyClass(keyClass);
		Option oValue = SequenceFile.Writer.valueClass(valueClass);
		Option oCmp = SequenceFile.Writer.compression(CompressionType.valueOf(getCompressionType()));

		return SequenceFile.createWriter(newConf, oFile, oKey, oValue, oCmp);
	}

	public SequenceFile.Writer getSequenceFileWriter(final Configuration conf, final Path sequenceFilePath) throws IOException {
		return getSequenceFileWriter(getKeyClass(), getValueClass(), conf, sequenceFilePath);
	}

	public Class<? extends Writable> getKeyClass() {
		return keyClass;
	}

	@Required
	public void setKeyClass(Class<? extends Writable> keyClass) {
		this.keyClass = keyClass;
	}

	public Class<? extends Writable> getValueClass() {
		return valueClass;
	}

	@Required
	public void setValueClass(Class<? extends Writable> valueClass) {
		this.valueClass = valueClass;
	}

	public String getCompressionType() {
		return compressionType;
	}

	@Required
	public void setCompressionType(String compressionType) {
		this.compressionType = compressionType;
	}

	public String getBlockSize() {
		return blockSize;
	}

	public void setBlockSize(String blockSize) {
		this.blockSize = blockSize;
	}

}
