/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.eagle.workflows.nodes.transform.editions;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class EditionXsltUnaryFunction
implements UnaryFunction<String, String> {
    private static final Log log = LogFactory.getLog(EditionXsltUnaryFunction.class);
    private final ApplyXslt xslt;
    private final SAXReader reader;

    public EditionXsltUnaryFunction(String xsltPath, Map<String, String> xsltParams) {
        this.xslt = new ApplyXslt((Source)new StreamSource(new File(xsltPath)), xsltPath, xsltParams);
        this.reader = new SAXReader();
    }

    public String evaluate(String input) {
        try {
            Document doc = this.reader.read((Reader)new StringReader(input));
            Node result = doc.selectSingleNode("//*[local-name()='metadata']/*");
            String edition = this.xslt.evaluate((Object)result.asXML());
            result.detach();
            ((Element)doc.selectSingleNode("//*[local-name()='metadata']")).add(this.reader.read((Reader)new StringReader(edition)).getRootElement());
            return doc.asXML();
        }
        catch (DocumentException e) {
            log.error((Object)("Problem creating dom4j document from \n" + input), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

