/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.eagle.workflows.nodes.backlink.translations;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.eagle.workflows.nodes.backlink.translations.HasTranslationFragment;
import eu.dnetlib.msro.eagle.workflows.nodes.backlink.translations.TranslationInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class TranslationBacklinkUnaryFunction
implements UnaryFunction<String, String> {
    private static final Log log = LogFactory.getLog(TranslationBacklinkUnaryFunction.class);
    private final SAXReader reader = new SAXReader();
    private final Map<String, List<TranslationInfo>> eagleIdToTranslationsInfo = Maps.newHashMap();

    public TranslationBacklinkUnaryFunction(Iterator<String> translationIterator) {
        while (translationIterator.hasNext()) {
            String translationRecord = translationIterator.next();
            try {
                this.processTranslationRecord(translationRecord, this.eagleIdToTranslationsInfo);
            }
            catch (DocumentException e) {
                log.error((Object)"Error during the pre-processing of MediaWiki translations", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void processTranslationRecord(String translationRecord, Map<String, List<TranslationInfo>> eagleIdToTranslations) throws DocumentException {
        Document doc = this.reader.read((Reader)new StringReader(translationRecord));
        List eagleIdList = doc.selectNodes("//*[local-name()='hasArtifact']/*[local-name()='dnetResourceIdentifier']");
        for (Node e : eagleIdList) {
            String[] tokens = e.getText().split("::");
            String eagleId = tokens[0] + "::" + tokens[1];
            List<Object> translationInfoList = eagleIdToTranslations.containsKey(eagleId) ? eagleIdToTranslations.get(eagleId) : Lists.newArrayList();
            TranslationInfo info = new TranslationInfo();
            info.setDnetResourceIdentifier(doc.valueOf("//*[local-name()='eagleObject']/*[local-name()='dnetResourceIdentifier']"));
            info.setProviderAcronym(doc.valueOf("//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']/@providerAcronym"));
            info.setProviderName(doc.valueOf("//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']/@providerName"));
            info.setLandingPage(doc.valueOf("//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']/@landingPage"));
            info.setLocalId(doc.valueOf("//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']"));
            info.setText(doc.valueOf("//*[local-name()='translation']/*[local-name()='text']"));
            info.setLang(doc.valueOf("//*[local-name()='translation']/*[local-name()='text']/@lang"));
            translationInfoList.add(info);
            eagleIdToTranslations.put(eagleId, translationInfoList);
        }
    }

    public String evaluate(String record) {
        try {
            Document doc = this.reader.read((Reader)new StringReader(record));
            String eagleObjId = doc.valueOf("//*[local-name()='eagleObject']/*[local-name()='dnetResourceIdentifier']");
            String[] tokens = eagleObjId.split("::");
            eagleObjId = tokens[0] + "::" + tokens[1];
            if (!this.eagleIdToTranslationsInfo.containsKey(eagleObjId)) {
                return record;
            }
            Element injectionPoint = (Element)doc.selectSingleNode("//*[local-name()='inscription']");
            if (injectionPoint == null && (injectionPoint = (Element)doc.selectSingleNode("//*[local-name()='transcription']")) == null) {
                injectionPoint = (Element)doc.selectSingleNode("//*[local-name()='visualRepresentation']");
            }
            List<TranslationInfo> translationsInfoList = this.eagleIdToTranslationsInfo.get(eagleObjId);
            for (TranslationInfo translationInfo : translationsInfoList) {
                String fragment = HasTranslationFragment.generateFragment(translationInfo);
                Document fragmentDoc = new SAXReader().read((Reader)new StringReader(fragment));
                injectionPoint.add(fragmentDoc.getRootElement());
            }
            return doc.asXML();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }
}

