/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.provision.epidoc;

import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.provision.epidoc.MdIdResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class EpidocRecordProvider {
    private static final Log log = LogFactory.getLog(EpidocRecordProvider.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private MdIdResolver resolver;

    @RequestMapping(value={"/epidoc/{objIdentfier}"})
    public void provideEpidoc(HttpServletRequest request, HttpServletResponse response, @PathVariable String objIdentfier) throws IOException, DocumentException, ISLookUpException, MDStoreServiceException {
        String record;
        log.info((Object)("Retrieve original Epidoc record id = " + objIdentfier));
        String repoAcronym = objIdentfier.split("::")[0];
        try {
            record = ((MDStoreService)this.serviceLocator.getService(MDStoreService.class)).deliverRecord(this.resolver.resolveMdId(repoAcronym), objIdentfier);
        }
        catch (DocumentNotFoundException e) {
            response.getWriter().write("The record identifier is invalid or not present");
            return;
        }
        catch (IndexOutOfBoundsException e) {
            response.getWriter().write("The record identifier is invalid");
            return;
        }
        Document doc = new SAXReader().read((Reader)new StringReader(record));
        Node teiNode = doc.selectSingleNode("//*[local-name()='TEI']");
        if (teiNode != null) {
            response.setHeader("Content-Type", "text/xml; charset=UTF-8");
            response.getWriter().write(doc.selectSingleNode("//*[local-name()='TEI']").asXML());
        } else {
            response.getWriter().write("EpiDoc representation not available for this record");
        }
    }
}

