/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.rmi;

import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.DownloadItem;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public abstract class AbstractDownloadPlugin {
    protected List<String> regularExpression;

    public DownloadItem checkOpenAccess(DownloadItem input) {
        if (input != null) {
            DownloadItem.OpenAccessValues openAccess = DownloadItem.OpenAccessValues.valueOf(input.getOpenAccess());
            switch (openAccess) {
                case OPEN: {
                    return input;
                }
                case CLOSED: 
                case RESTRICTED: 
                case UNKNOWN: {
                    return null;
                }
                case EMBARGO: {
                    DateTime today;
                    if (input.getEmbargoDate() == null) {
                        return null;
                    }
                    DateTime embargoDate = new DateTime((Object)input.getEmbargoDate());
                    Days days = Days.daysBetween((ReadableInstant)embargoDate, (ReadableInstant)(today = new DateTime()));
                    if (days.getDays() <= 0) {
                        return input;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public DownloadItem filterByRegexp(DownloadItem input) {
        if (this.regularExpression != null && this.regularExpression.size() > 0) {
            String baseURLs = input.getUrl();
            List urlsList = (List)new Gson().fromJson(baseURLs, List.class);
            for (String baseURL : urlsList) {
                for (String regExp : this.regularExpression) {
                    if (!baseURL.matches(regExp)) continue;
                    return input;
                }
            }
            return null;
        }
        return input;
    }

    protected boolean checkUrlsNotNull(DownloadItem input, List<String> urls) {
        for (String s : urls) {
            String newURL = this.extractURL(s);
            if (newURL == null) continue;
            input.setOriginalUrl(s);
            input.setUrl(newURL);
            return true;
        }
        return false;
    }

    public abstract String extractURL(String var1);

    public List<String> getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(List<String> regularExpression) {
        this.regularExpression = regularExpression;
    }
}

