/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.hadoop.hbase;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.hadoop.hbase.AbstractHBaseAdminJobNode;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateHBaseTableJobNode
extends AbstractHBaseAdminJobNode {
    private static final Log log = LogFactory.getLog(CreateHBaseTableJobNode.class);
    private boolean reuseRegionInfo = false;

    protected String execute(NodeToken token) throws Exception {
        Set<String> columns = this.getColumns(token);
        String tableName = this.tableName(token);
        String cluster = this.cluster(token);
        log.info((Object)("Ensuring table " + tableName + " on cluster: '" + cluster + "' - columns: " + columns));
        if (this.isReuseRegionInfo()) {
            String jsonConf = token.getEnv().getAttribute(this.getTableConfigurationParamName());
            if (StringUtils.isBlank((String)jsonConf)) {
                throw new MSROException("cannot find HBase table configuration in workflow env");
            }
            ((HadoopService)this.getServiceLocator().getService(HadoopService.class)).createConfiguredHbaseTable(cluster, tableName, jsonConf);
        } else {
            ((HadoopService)this.getServiceLocator().getService(HadoopService.class)).createHbaseTable(cluster, tableName, columns);
        }
        return Arc.DEFAULT_ARC;
    }

    public boolean isReuseRegionInfo() {
        return this.reuseRegionInfo;
    }

    public void setReuseRegionInfo(boolean reuseRegionInfo) {
        this.reuseRegionInfo = reuseRegionInfo;
    }
}

