/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.dedup.DedupConfigurationAwareJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MinDistSearchHadoopJobNode
extends DedupConfigurationAwareJobNode {
    private static final Log log = LogFactory.getLog(MinDistSearchHadoopJobNode.class);
    private static final String StatusParam = "MinDistSearchHadoopJobNode.status";
    private static final String DepthParam = "mindist_recursion_depth";
    private static final String UpdateCounterParam = "UpdateCounter.UPDATED";
    private static final String DebugParam = "mindist_DEBUG";
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private boolean debug = false;
    private String outPathParam;

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        String depthString = token.getFullEnv().getAttribute(DepthParam);
        log.debug((Object)String.format("found depthParam: '%s'", depthString));
        if (StringUtils.isBlank((String)depthString)) {
            depthString = "0";
        }
        int depth = Integer.valueOf(depthString);
        String cluster = token.getEnv().getAttribute("cluster");
        String outputPath = this.getPath(token.getEnv().getAttribute("workDir"), depth);
        HadoopService hadoopService = (HadoopService)this.serviceLocator.getService(HadoopService.class);
        switch (this.getStatusFromEnv(token)) {
            case DATALOAD: {
                this.setHadoopJob("dedupSimilarity2GraphJob");
                job.getParameters().put("mapred.output.dir", this.getPath(token.getEnv().getAttribute("workDir"), depth) + "/out");
                hadoopService.createHdfsDirectory(cluster, outputPath, true);
                break;
            }
            case DEPTH_N: {
                this.setHadoopJob("dedupMinDistGraphJob");
                String newOutputPath = this.getPath(token.getEnv().getAttribute("workDir"), depth + 1);
                hadoopService.createHdfsDirectory(cluster, newOutputPath, true);
                job.getParameters().put(DepthParam, String.valueOf(depth));
                job.getParameters().put(DebugParam, String.valueOf(this.isDebug()));
                job.getParameters().put("mapred.input.dir", outputPath + "/out");
                job.getParameters().put("mapred.output.dir", newOutputPath + "/out");
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("input job parameters: %s", job.getParameters()));
                }
                token.getFullEnv().setAttribute(DepthParam, String.valueOf(depth + 1));
                token.getFullEnv().setAttribute(this.getOutPathParam(), newOutputPath + "/out");
            }
        }
        super.prepareJob(job, token);
    }

    private String getPath(String basePath, int depth) {
        Path path = FileSystems.getDefault().getPath(basePath, "depth_" + depth);
        return path.toAbsolutePath().toString();
    }

    private STATUS getStatusFromEnv(NodeToken token) {
        if (StringUtils.isBlank((String)token.getEnv().getAttribute(StatusParam))) {
            return STATUS.DATALOAD;
        }
        STATUS current = STATUS.DATALOAD;
        try {
            current = STATUS.valueOf(token.getEnv().getAttribute(StatusParam));
            log.debug((Object)("found status: " + current.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return current;
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(final Engine engine, final NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            protected void onDone(BlackboardJob job) {
                STATUS status = MinDistSearchHadoopJobNode.this.getStatusFromEnv(token);
                log.debug((Object)("complete phase: " + (Object)((Object)status)));
                switch (status) {
                    case DATALOAD: {
                        token.getFullEnv().setAttribute(MinDistSearchHadoopJobNode.StatusParam, STATUS.DEPTH_N.toString());
                        token.getFullEnv().setAttribute(MinDistSearchHadoopJobNode.DepthParam, "0");
                        engine.complete(token, "depth_n");
                        break;
                    }
                    case DEPTH_N: {
                        String counter;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("return job parameters: %s=%s, %s=%s", MinDistSearchHadoopJobNode.DepthParam, job.getParameters().get(MinDistSearchHadoopJobNode.DepthParam), MinDistSearchHadoopJobNode.UpdateCounterParam, job.getParameters().get(MinDistSearchHadoopJobNode.UpdateCounterParam)));
                        }
                        if (StringUtils.isBlank((String)(counter = (String)job.getParameters().get(MinDistSearchHadoopJobNode.UpdateCounterParam)))) {
                            token.getFullEnv().removeAttribute(MinDistSearchHadoopJobNode.StatusParam);
                            token.getFullEnv().removeAttribute(MinDistSearchHadoopJobNode.DepthParam);
                            log.info((Object)String.format("done iteration %s:%s", MinDistSearchHadoopJobNode.UpdateCounterParam, 0));
                            engine.complete(token, Arc.DEFAULT_ARC);
                            break;
                        }
                        log.info((Object)String.format("continue with next iteration %s:%s", MinDistSearchHadoopJobNode.UpdateCounterParam, counter));
                        engine.complete(token, "depth_n");
                    }
                }
            }
        };
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getOutPathParam() {
        return this.outPathParam;
    }

    public void setOutPathParam(String outPathParam) {
        this.outPathParam = outPathParam;
    }

    static enum STATUS {
        DATALOAD,
        DEPTH_N;

    }
}

