package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.hadoop.SubmitHadoopJobNode;
import eu.dnetlib.pace.config.DedupConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupConfigurationAwareJobNode extends SubmitHadoopJobNode {

	private static final Log log = LogFactory.getLog(DedupConfigurationAwareJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String dedupConfigSequenceParam;

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		super.prepareJob(job, token);

		final DedupConfigurationOrchestration dedupConfigurations = dedupConfigurations(token);
		final DedupConfig currentConf = dedupConfigurations.getConfigurations().peek();

		log.debug("using dedup configuration: '" + currentConf + "'");

		job.getParameters().put("dedup.conf", currentConf.toString());

		token.getEnv().setAttribute("dedup.conf", currentConf.toString());
	}

	protected DedupConfigurationOrchestration dedupConfigurations(final NodeToken token) {
		final String configs = token.getFullEnv().getAttribute(getDedupConfigSequenceParam());
		if ((configs == null) || configs.trim().isEmpty())
			throw new IllegalStateException("Cannot find dedup configurations in workflow env: '" + getDedupConfigSequenceParam() + "'");

		return DedupConfigurationOrchestration.fromJSON(configs);
	}

	protected String getEntityType(final NodeToken token) {
		final String entityType = token.getEnv().getAttribute("entityType");
		if (StringUtils.isBlank(entityType)) throw new IllegalStateException("Cannot find 'entityType' parameter in workflow env.");
		return entityType;
	}

	// //////////

	public String getDedupConfigSequenceParam() {
		return dedupConfigSequenceParam;
	}

	public void setDedupConfigSequenceParam(final String dedupConfigSequenceParam) {
		this.dedupConfigSequenceParam = dedupConfigSequenceParam;
	}

}
