package eu.dnetlib.functionality.modular.ui.dedup;

/**
 * Utility Class EntityType, helps the user interface to display the different entity types.
 */
public class EntityType {

	/** The id. */
	private String id;

	/** The type. */
	private String type;

	/** The label. */
	private String label;

	/**
	 * Instantiates a new entity type.
	 */
	public EntityType() {};

	/**
	 * Instantiates a new entity type.
	 *
	 * @param id
	 *            the id
	 * @param type
	 *            the type
	 * @param label
	 *            the label
	 */
	public EntityType(final String id, final String type, final String label) {
		super();
		setId(id);
		setType(type);
		setLabel(label);
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	public void setId(final String id) {
		this.id = id;
	}

	/**
	 * Gets the type.
	 *
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * Sets the type.
	 *
	 * @param type
	 *            the new type
	 */
	public void setType(final String type) {
		this.type = type;
	}

	/**
	 * Gets the label.
	 *
	 * @return the label
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * Sets the label.
	 *
	 * @param label
	 *            the new label
	 */
	public void setLabel(final String label) {
		this.label = label;
	}

}
