package eu.dnetlib.msro.workflows.actions;

import org.apache.commons.lang.StringUtils;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class PromoteActionsJobNode extends BlackboardJobNode {

	public static final String ALL_SETS = "ALL SETS";

	private String set;

	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(ActionManagerService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction("PROMOTE");
		if (!StringUtils.isBlank(getSet()) && !getSet().equals(ALL_SETS)) {
			job.getParameters().put("set", getSet());
			token.getEnv().setAttribute("set", getSet());
		}
	}

	public String getSet() {
		return set;
	}

	public void setSet(final String set) {
		this.set = set;
	}

}
