package eu.dnetlib.msro.workflows.actions;

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

/**
 * The Class PrepareConfiguredActionSetJobNode.
 */
public class PrepareConfiguredActionSetJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(PrepareConfiguredActionSetJobNode.class);

	/** The dedup config sequence param. */
	private String dedupConfigSequenceParam;

	/** The job property. */
	private String jobProperty;

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final NodeToken token) throws Exception {

		final List<Map<String, String>> setList = Lists.newArrayList();

		final Map<String, String> set = Maps.newHashMap();

		set.put("rawset", RawSet.newInstance().getId());
		set.put("creationDate", DateUtils.now_ISO8601());
		set.put("set", getActionSetId(token));
		set.put("enabled", "true");
		set.put("jobProperty", getJobProperty());

		token.getEnv().setAttribute(set.get("jobProperty"), set.get("rawset"));

		setList.add(set);
		final String sets = new Gson().toJson(setList);
		log.debug("built set: " + sets);

		token.getEnv().setAttribute("sets", sets);

		return Arc.DEFAULT_ARC;
	}

	/**
	 * Gets the action set id.
	 *
	 * @param token
	 *            the token
	 * @return the action set id
	 */
	private String getActionSetId(final NodeToken token) {
		final String json = token.getEnv().getAttribute(getDedupConfigSequenceParam());
		final DedupConfigurationOrchestration dco = DedupConfigurationOrchestration.fromJSON(json);
		final String actionSetId = dco.getActionSetId();
		log.info("found actionSetId in workflow env: " + actionSetId);
		return actionSetId;
	}

	/**
	 * Gets the dedup config sequence param.
	 *
	 * @return the dedup config sequence param
	 */
	public String getDedupConfigSequenceParam() {
		return dedupConfigSequenceParam;
	}

	/**
	 * Sets the dedup config sequence param.
	 *
	 * @param dedupConfigSequenceParam
	 *            the new dedup config sequence param
	 */
	public void setDedupConfigSequenceParam(final String dedupConfigSequenceParam) {
		this.dedupConfigSequenceParam = dedupConfigSequenceParam;
	}

	/**
	 * Gets the job property.
	 *
	 * @return the job property
	 */
	public String getJobProperty() {
		return jobProperty;
	}

	/**
	 * Sets the job property.
	 *
	 * @param jobProperty
	 *            the new job property
	 */
	public void setJobProperty(final String jobProperty) {
		this.jobProperty = jobProperty;
	}

}
