/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.hadoop;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexDSUpdateJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(IndexDSUpdateJobNode.class);
    public static final String N_RECORDS_PARAM = "blackboard:param:index.status code: 0";
    @Resource
    private UniqueServiceLocator serviceLocator;

    public String execute(NodeToken token) throws Exception {
        String dsId = token.getEnv().getAttribute("index_id");
        String version = token.getEnv().getAttribute("index.feed.timestamp");
        try {
            int count = Integer.parseInt(token.getEnv().getAttribute(N_RECORDS_PARAM));
            log.info((Object)("updating indexDS: " + dsId + " version: " + version + " record count: " + count));
            this.updateIndexDS(dsId, version, count);
        }
        catch (NumberFormatException e) {
            log.warn((Object)"unable to find index feeding details in the workflow env, skippind DS update");
        }
        return Arc.DEFAULT_ARC;
    }

    private boolean updateIndexDS(String dsId, String version, long count) throws ISRegistryException {
        String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']" + " return update value $x//INDEX_SIZE with " + String.valueOf(count) + "," + "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']" + " return update value $x//INDEX_LAST_UPDATE with '" + version + "' ";
        log.debug((Object)("\n\n updating indexDataStructure: " + xquery + "\n\n"));
        return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(xquery);
    }
}

