/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareConfiguredActionSetJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareConfiguredActionSetJobNode.class);
    private String dedupConfigSequenceParam;
    private String jobProperty;

    protected String execute(NodeToken token) throws Exception {
        ArrayList setList = Lists.newArrayList();
        HashMap set = Maps.newHashMap();
        set.put("rawset", RawSet.newInstance().getId());
        set.put("creationDate", DateUtils.now_ISO8601());
        set.put("set", this.getActionSetId(token));
        set.put("enabled", "true");
        set.put("jobProperty", this.getJobProperty());
        token.getEnv().setAttribute((String)set.get("jobProperty"), (String)set.get("rawset"));
        setList.add(set);
        String sets = new Gson().toJson((Object)setList);
        log.debug((Object)("built set: " + sets));
        token.getEnv().setAttribute("sets", sets);
        return Arc.DEFAULT_ARC;
    }

    private String getActionSetId(NodeToken token) {
        String json = token.getEnv().getAttribute(this.getDedupConfigSequenceParam());
        DedupConfigurationOrchestration dco = DedupConfigurationOrchestration.fromJSON(json);
        String actionSetId = dco.getActionSetId();
        log.info((Object)("found actionSetId in workflow env: " + actionSetId));
        return actionSetId;
    }

    public String getDedupConfigSequenceParam() {
        return this.dedupConfigSequenceParam;
    }

    public void setDedupConfigSequenceParam(String dedupConfigSequenceParam) {
        this.dedupConfigSequenceParam = dedupConfigSequenceParam;
    }

    public String getJobProperty() {
        return this.jobProperty;
    }

    public void setJobProperty(String jobProperty) {
        this.jobProperty = jobProperty;
    }
}

