/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.dedup;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafEntityDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.transform.OafEntityMerger;
import eu.dnetlib.data.transform.ProtoDocumentMapper;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.functionality.index.client.IndexClient;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.client.ResolvingIndexClientFactory;
import eu.dnetlib.functionality.index.client.response.LookupResponse;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroup;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.pace.config.DedupConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DedupServiceInternalController
extends AbstractAjaxController {
    private static final String ID_PREFIX_REGEX = "^\\d\\d\\|";
    private static final Log log = LogFactory.getLog(DedupServiceInternalController.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;
    @Value(value="${dnet.dedup.db.name}")
    private String dbName;
    @Autowired
    private ResolvingIndexClientFactory indexClientFactory;
    @Value(value="${dnet.dedup.index.format}")
    private String indexFormat;
    @Value(value="${dnet.dedup.index.collection}")
    private String dedupIndexCollection;
    private IndexClient indexClient = null;
    private static Map<String, Map<String, String>> paths = Maps.newHashMap();

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/lookupConfigurations.do"})
    public Map<String, List<String>> lookupConfigurations() throws ISLookUpException {
        HashMap res = Maps.newHashMap();
        ISLookUpService lookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String listEntityTypesXQuery = "distinct-values(for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType'] return $x//ENTITY/@name/string())";
        for (String entityType : lookUpService.quickSearchProfile("distinct-values(for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType'] return $x//ENTITY/@name/string())")) {
            String xquery = String.format("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType' and .//ENTITY/@name='%s' ] return $x//ACTION_SET/@id/string()", entityType);
            res.put(entityType, lookUpService.quickSearchProfile(xquery));
        }
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/search.do"})
    public OafResult search(@RequestParam(value="entityType", required=true) String type, @RequestParam(value="query", required=true) String userQuery, @RequestParam(value="actionSet", required=true) String actionSet, @RequestParam(value="start", required=true) int start, @RequestParam(value="rows", required=true) int rows, @RequestParam(value="fields", required=true) String fields) throws Exception {
        try {
            String cqlQuery = String.format("(>s=SOLR s.q.op=AND) and oaftype = %s and actionset exact \"%s\" and deletedbyinference = false and %s", type, actionSet, userQuery);
            LookupResponse rsp = this.getIndexClient().lookup(cqlQuery, null, start, start + rows - 1);
            LinkedList fieldList = Lists.newLinkedList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)fields));
            LinkedList resList = Lists.newLinkedList((Iterable)Iterables.transform(this.toOaf(rsp), this.getOaf2FieldMapFunction(type, fieldList)));
            return new OafResult(rsp.getTotal(), resList);
        }
        catch (Exception e) {
            log.error((Object)"search error", (Throwable)e);
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/searchById.do"})
    public OafResult searchById(@RequestParam(value="entityType", required=true) String type, @RequestParam(value="objidentifier", required=true) String objidentifier, @RequestParam(value="fields", required=true) List<String> fields) throws Exception {
        String cqlQuery = "objidentifier exact \"" + objidentifier + "\"";
        LookupResponse rsp = this.getIndexClient().lookup(cqlQuery, null, 0, 1);
        Iterable<OafProtos.Oaf> oafList = this.toOaf(rsp);
        LinkedList resList = Lists.newLinkedList((Iterable)Iterables.transform(oafList, this.getOaf2FieldMapFunction(type, fields)));
        return new OafResult(rsp.getTotal(), resList);
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/commit.do"})
    public boolean addSimRels(@RequestBody(required=true) SimilarityGroup group) throws Exception {
        try {
            DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
            String version = InputDocumentFactory.getParsedDateField((String)DateUtils.now_ISO8601());
            group.setId(UUID.randomUUID().toString());
            group.setDate(version);
            log.info((Object)("adding similarities: " + group.getGroup()));
            this.updateGroupSql(dbService, group, version);
            log.info((Object)("adding dissimilarities: " + group.getDissimilar()));
            this.dissimilaritiesSql(dbService, group);
            log.info((Object)"starting index update");
            CloudSolrServer solrServer = this.getSolrServer();
            ProtoDocumentMapper mapper = this.initProtoMapper();
            HashMap config = Maps.newHashMap();
            config.put("entityType", group.getEntityType().getType());
            config.put("configurationId", group.getActionSet());
            DedupConfig dedupConf = DedupConfig.loadDefault((Map)config);
            for (String rootId : group.getRootIds()) {
                solrServer.deleteById(rootId);
            }
            Function<OafProtos.Oaf, SolrInputDocument> oaf2solr = this.oaf2solr(version, group.getActionSet(), mapper);
            LinkedList buffer = Lists.newLinkedList();
            ArrayList groupDocs = Lists.newArrayList(this.markDeleted(this.asOafBuilder(this.parseBase64(this.queryIndex(group.getGroup())))));
            buffer.addAll(Lists.newArrayList(this.asIndexDocs(oaf2solr, groupDocs)));
            SolrInputDocument newRoot = (SolrInputDocument)oaf2solr.apply((Object)OafEntityMerger.merge((DedupConfig)dedupConf, (String)this.newRootId(group), (Iterable)groupDocs).build());
            newRoot.setField("actionset", (Object)dedupConf.getWf().getConfigurationId());
            buffer.add(newRoot);
            ArrayList dissimDocs = Lists.newArrayList(this.markUnDeleted(this.asOafBuilder(this.parseBase64(this.queryIndex(group.getDissimilar().keySet())))));
            buffer.addAll(Lists.newArrayList(this.asIndexDocs(oaf2solr, dissimDocs)));
            log.debug((Object)String.format("adding %d documents to index %s", buffer.size(), this.dedupIndexCollection));
            int addStatus = solrServer.add((Collection)buffer).getStatus();
            log.debug((Object)("solr add status: " + addStatus));
            int commitStatus = solrServer.commit().getStatus();
            log.debug((Object)("solr commit status: " + commitStatus));
            return addStatus == 0 && commitStatus == 0;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    private IndexClient getIndexClient() throws IndexClientException, ISLookUpDocumentNotFoundException, ISLookUpException {
        if (this.indexClient == null) {
            this.indexClient = this.indexClientFactory.getClient(this.indexFormat, "index", "dedup", "solr");
        }
        return this.indexClient;
    }

    private Function<OafProtos.Oaf, Map<String, String>> getOaf2FieldMapFunction(final String type, final List<String> fields) {
        return new Function<OafProtos.Oaf, Map<String, String>>(){

            public Map<String, String> apply(OafProtos.Oaf oaf) {
                OafEntityDecoder ed = OafDecoder.decode((OafProtos.Oaf)oaf).decodeEntity();
                HashMap res = Maps.newHashMap();
                String oafId = DedupServiceInternalController.this.cleanId(oaf.getEntity().getId());
                ArrayList idList = Lists.newArrayList((Iterable)Iterables.transform((Iterable)oaf.getEntity().getChildrenList(), (Function)new Function<OafProtos.OafEntity, String>(){

                    public String apply(OafProtos.OafEntity e) {
                        return DedupServiceInternalController.this.cleanId(e.getId());
                    }
                }));
                if (idList.isEmpty()) {
                    idList.add(oafId);
                }
                res.put("id", oafId);
                res.put("idList", Joiner.on((String)",").join((Iterable)idList));
                res.put("groupSize", idList.isEmpty() ? "1" : idList.size() + "");
                for (String fieldName : fields) {
                    res.put(fieldName, Joiner.on((String)"; ").skipNulls().join((Iterable)ed.getFieldValues(fieldName, (String)((Map)paths.get(type)).get(fieldName))));
                }
                return res;
            }
        };
    }

    private String cleanId(String id) {
        return id.replaceFirst(ID_PREFIX_REGEX, "");
    }

    private String newRootId(SimilarityGroup group) {
        if (group.getRootIds().isEmpty()) {
            return "dedup_wf_001::" + Collections.min(group.getGroup()).replaceFirst("^.*::", "");
        }
        return Collections.min(group.getRootIds());
    }

    private Iterable<SolrInputDocument> asIndexDocs(Function<OafProtos.Oaf, SolrInputDocument> mapper, Iterable<OafProtos.Oaf> a) {
        return Iterables.transform(a, mapper);
    }

    private Function<OafProtos.Oaf, SolrInputDocument> oaf2solr(final String version, final String actionSetId, final ProtoDocumentMapper mapper) {
        return new Function<OafProtos.Oaf, SolrInputDocument>(){

            public SolrInputDocument apply(OafProtos.Oaf oaf) {
                try {
                    return mapper.map((GeneratedMessage)oaf, version, "", actionSetId);
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("unable to map proto to index document", e);
                }
            }
        };
    }

    private Iterable<String> queryIndex(Iterable<String> ids) {
        return Iterables.transform(ids, this.idToIndexDocumentMapper());
    }

    private Function<String, String> idToIndexDocumentMapper() {
        return new Function<String, String>(){

            public String apply(String id) {
                try {
                    String cql = "objidentifier exact \"" + id + "\"";
                    LookupResponse rsp = DedupServiceInternalController.this.getIndexClient().lookup(cql, null, 0, 1);
                    log.debug((Object)String.format("query index for id '%s', found '%d'", id, rsp.getTotal()));
                    return (String)Iterables.getOnlyElement((Iterable)rsp.getRecords());
                }
                catch (Throwable e) {
                    throw new RuntimeException("unable to query id: " + id);
                }
            }
        };
    }

    private Iterable<OafProtos.Oaf> parseBase64(Iterable<String> r) {
        return Iterables.transform(r, this.getXml2OafFunction());
    }

    private ProtoDocumentMapper initProtoMapper() throws DocumentException, ISLookUpException, ISLookUpDocumentNotFoundException {
        return new ProtoDocumentMapper(((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='" + this.indexFormat + "']//LAYOUT[@name='index']/FIELDS"));
    }

    private Iterable<OafProtos.Oaf> markDeleted(Iterable<OafProtos.Oaf.Builder> builders) {
        return Iterables.transform(builders, (Function)new Function<OafProtos.Oaf.Builder, OafProtos.Oaf>(){

            public OafProtos.Oaf apply(OafProtos.Oaf.Builder builder) {
                builder.getDataInfoBuilder().setDeletedbyinference(true);
                return builder.build();
            }
        });
    }

    private Iterable<OafProtos.Oaf> markUnDeleted(Iterable<OafProtos.Oaf.Builder> builders) {
        return Iterables.transform(builders, (Function)new Function<OafProtos.Oaf.Builder, OafProtos.Oaf>(){

            public OafProtos.Oaf apply(OafProtos.Oaf.Builder builder) {
                builder.getDataInfoBuilder().setDeletedbyinference(false);
                return builder.build();
            }
        });
    }

    private Iterable<OafProtos.Oaf.Builder> asOafBuilder(Iterable<OafProtos.Oaf> oaf) {
        return Iterables.transform(oaf, (Function)new Function<OafProtos.Oaf, OafProtos.Oaf.Builder>(){

            public OafProtos.Oaf.Builder apply(OafProtos.Oaf oaf) {
                return OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf);
            }
        });
    }

    private Function<String, OafProtos.Oaf> getXml2OafFunction() {
        return new Function<String, OafProtos.Oaf>(){

            public OafProtos.Oaf apply(String s) {
                String base64 = StringUtils.substringBefore((String)StringUtils.substringAfter((String)s, (String)">"), (String)"<");
                try {
                    byte[] oaf = Base64.decodeBase64((String)base64);
                    return OafDecoder.decode((byte[])oaf).getOaf();
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("unable to decode base64 encoded Oaf object: " + base64);
                }
            }
        };
    }

    private Iterable<OafProtos.Oaf> toOaf(LookupResponse rsp) {
        return Iterables.transform((Iterable)rsp.getRecords(), this.getXml2OafFunction());
    }

    private void updateGroupSql(DatabaseService dbService, SimilarityGroup group, String version) throws Exception {
        for (String id : group.getGroup()) {
            this.safeUpdateSql(dbService, String.format("DELETE FROM similarity_groups WHERE objidentifier = '%s'; ", id));
        }
        String type = group.getEntityType().getType();
        this.safeUpdateSql(dbService, String.format("INSERT INTO groups(id, entitytype, date, actionsetid) VALUES('%s', '%s', '%s', '%s'); ", group.getId(), type, version, group.getActionSet()));
        for (String id : group.getGroup()) {
            if (!dbService.contains(this.dbName, "entities", "id", id)) {
                this.safeUpdateSql(dbService, String.format("INSERT INTO entities(id, entitytype) VALUES('%s', '%s'); ", id, type));
            }
            this.safeUpdateSql(dbService, String.format("INSERT INTO similarity_groups(groupid, objidentifier) VALUES('%s', '%s'); ", group.getId(), id));
        }
    }

    private void dissimilaritiesSql(DatabaseService dbService, SimilarityGroup group) {
        String type = group.getEntityType().getType();
        for (Map.Entry<String, Set<String>> e : group.getDissimilar().entrySet()) {
            if (!dbService.contains(this.dbName, "entities", "id", e.getKey())) {
                this.safeUpdateSql(dbService, String.format("INSERT INTO entities(id, entitytype) VALUES('%s', '%s'); ", e.getKey(), type));
            }
            for (String id : e.getValue()) {
                if (dbService.contains(this.dbName, "entities", "id", id)) continue;
                this.safeUpdateSql(dbService, String.format("INSERT INTO entities(id, entitytype) VALUES('%s', '%s'); ", id, type));
            }
        }
        for (Map.Entry<String, Set<String>> e : group.getDissimilar().entrySet()) {
            for (String id : e.getValue()) {
                this.safeUpdateSql(dbService, String.format("INSERT INTO dissimilarities(id1, id2, actionsetid) VALUES('%s', '%s', '%s'); ", e.getKey(), id, group.getActionSet()));
            }
        }
    }

    private boolean safeUpdateSql(DatabaseService dbService, String sql) {
        try {
            log.info((Object)sql);
            return dbService.updateSQL(this.dbName, sql);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage());
            log.debug((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            return false;
        }
    }

    private CloudSolrServer getSolrServer() {
        String zk = this.getIndexSolrUrlZk();
        log.info((Object)String.format("initializing solr client for collection %s, zk url: %s", this.dedupIndexCollection, zk));
        CloudSolrServer solrServer = new CloudSolrServer(zk);
        solrServer.setDefaultCollection(this.dedupIndexCollection);
        return solrServer;
    }

    private String getIndexSolrUrlZk() {
        try {
            return this.getResourceProfileByQuery("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//PROTOCOL[./@name='solr']/@address/string()");
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("unable to read solr ZK url from service profile", e);
        }
    }

    private String getResourceProfileByQuery(String xquery) throws ISLookUpException {
        log.debug((Object)("quering for service property: " + xquery));
        String res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
        if (StringUtils.isBlank((String)res)) {
            throw new IllegalStateException("unable to find unique service property, xquery: " + xquery);
        }
        return res;
    }

    static {
        paths.put("result", new HashMap());
        paths.put("organization", new HashMap());
        paths.put("person", new HashMap());
        paths.get("result").put("title", "result/metadata/title/value");
        paths.get("result").put("dateofacceptance", "result/metadata/dateofacceptance/value");
        paths.get("result").put("description", "result/metadata/description/value");
        paths.get("result").put("author", "result/author/metadata/fullname/value");
        paths.get("organization").put("legalname", "organization/metadata/legalname/value");
        paths.get("organization").put("legalshortname", "organization/metadata/legalshortname/value");
        paths.get("organization").put("websiteurl", "organization/metadata/websiteurl/value");
        paths.get("organization").put("country", "organization/metadata/country/classid");
        paths.get("person").put("fullname", "person/metadata/fullname/value");
    }

    public class OafResult {
        private long total;
        private List<Map<String, String>> results;

        public OafResult(long total, List<Map<String, String>> results) {
            this.setTotal(total);
            this.setResults(results);
        }

        public long getTotal() {
            return this.total;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public List<Map<String, String>> getResults() {
            return this.results;
        }

        public void setResults(List<Map<String, String>> results) {
            this.results = results;
        }
    }
}

