package eu.dnetlib.actionmanager.hbase;

import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HBaseBlackboardJobListener extends AbstractBlackboardJobListener {

	private static final Log log = LogFactory.getLog(HBaseBlackboardJobListener.class);

	private HBaseCallback callback;

	public HBaseBlackboardJobListener(final HBaseCallback callback) {
		super();
		this.callback = callback;
	}

	@Override
	protected void onDone(final BlackboardJob job) {
		try {
			if (callback != null) {
				callback.onDone(job.getParameters());
			}
		} catch (Exception e) {
			log.error("fail to run a callback function");
		}
	}

	@Override
	protected void onFailed(final BlackboardJob job) {
		try {
			if (callback != null) {
				callback.onFailed(new ActionManagerException(job.getError()));
			}
		} catch (Exception e) {
			log.error("fail to run a callback function");
		}
	}
}
