package eu.dnetlib.actionmanager.hbase;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.XsltInfoPackageAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.miscutils.datetime.DateUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Required;

public class HBaseActionManagerCore {

	private ActionFactory actionFactory;

	private HBaseClient hbaseClient;

	private ISClient informationServiceClient;

	/*
	 * public void insertOrUpdateAtomicAction(AtomicAction action, String provenance, String trust) throws ActionManagerException {
	 * hbaseClient.writeOnHBase(action.asPutOperations(null, provenance, trust, null)); }
	 * 
	 * public void insertOrUpdateAtomicActions(List<AtomicAction> actions, String provenance, String trust) throws ActionManagerException {
	 * for (AtomicAction action : actions) { insertOrUpdateAtomicAction(action, provenance, trust); } }
	 */

	public XsltInfoPackageAction applyInfoPackageAction(final String splitRuleId,
			final String set,
			final Agent agent,
			final Operation operation,
			final String infoPackage,
			final Provenance provenance,
			final String trust,
			final String nsprefix) throws ActionManagerException {

		if (informationServiceClient.existsSet(set)) {
			final RawSet rawSet = informationServiceClient.geLatestRawSet(set);

			final XsltInfoPackageAction action = bulkApplyInfoPackageAction(splitRuleId, rawSet, agent, operation, infoPackage, provenance, trust, nsprefix);

			if (informationServiceClient.existsRawSet(rawSet.getId())) {
				informationServiceClient.updateLastUpdate(rawSet.getId());
			} else {
				rawSet.setLastUpdate(DateUtils.now_ISO8601());
				informationServiceClient.addLatestRawSet(set, rawSet);
			}

			return action;
		} else {
			throw new ActionManagerException("Missing set " + set);
		}
	}

	public XsltInfoPackageAction bulkApplyInfoPackageAction(final String splitRuleId,
			final RawSet rawSet,
			final Agent agent,
			final Operation operation,
			final String infoPackage,
			final Provenance provenance,
			final String trust,
			final String nsprefix) throws ActionManagerException {

		final XsltInfoPackageAction action = actionFactory.generateInfoPackageAction(splitRuleId, rawSet.getId(), agent, operation, infoPackage, provenance,
				nsprefix, trust);

		final List<Put> puts = action.asPutOperations();

		hbaseClient.write(puts);

		return action;
	}

	public void deleteInfoPackageAction(final String id) throws ActionManagerException {
		final Map<String, String> row = hbaseClient.getRow(Bytes.toBytes(id));
		final List<Delete> deletes = Lists.newArrayList();

		String rawSet = null;

		for (String key : row.keySet()) {
			if (key.startsWith("rel:")) {
				deletes.add(new Delete(Bytes.toBytes(key.substring(4))));
			} else if (key.startsWith("set:")) {
				rawSet = key.substring(4);
			}
		}
		deletes.add(new Delete(Bytes.toBytes(id)));

		if (rawSet != null) {
			informationServiceClient.updateLastUpdate(rawSet);
		}

		hbaseClient.delete(deletes);
	}

	public String getBasePathHDFS() throws ActionManagerException {
		return informationServiceClient.getBasePathHDFS();
	}

	public ActionFactory getActionFactory() {
		return actionFactory;
	}

	@Required
	public void setActionFactory(final ActionFactory actionFactory) {
		this.actionFactory = actionFactory;
	}

	public HBaseClient getHbaseClient() {
		return hbaseClient;
	}

	@Required
	public void setHbaseClient(final HBaseClient hbaseClient) {
		this.hbaseClient = hbaseClient;
	}

	public List<ActionManagerSet> listAvailableSets() throws ActionManagerException {
		return informationServiceClient.listSets();
	}

	public ISClient getInformationServiceClient() {
		return informationServiceClient;
	}

	@Required
	public void setInformationServiceClient(final ISClient informationServiceClient) {
		this.informationServiceClient = informationServiceClient;
	}

}
