package eu.dnetlib.actionmanager.blackboard;

import java.util.Map;

import eu.dnetlib.actionmanager.hbase.HBaseCallback;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class GarbageActionManagerAction extends AbstractActionManagerAction implements BlackboardServerAction<ActionManagerActions> {

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) {
		try {
			getHbaseJobLauncher().executeGarbageJob(new HBaseCallback() {

				@Override
				public void onDone(final Map<String, String> properties) {
					job.getParameters().putAll(properties);
					handler.done(job);
				}

				@Override
				public void onFailed(final Throwable e) {
					handler.failed(job, e);
				}
			});
		} catch (Exception e) {
			handler.failed(job, e);
		}
	}
}
