/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.is;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.ws.Endpoint;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class ISClient {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private StringTemplate actionManagerSetDsTemplate;
    private Endpoint endpoint;
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private static final Log log = LogFactory.getLog(ISClient.class);

    public String registerSetProfile(ActionManagerSet set) throws ActionManagerException {
        if (this.existsSet(set.getId())) {
            throw new ActionManagerException("Set " + set.getId() + " already registered");
        }
        try {
            StringTemplate template = new StringTemplate(this.actionManagerSetDsTemplate.getTemplate());
            template.setAttribute("serviceUri", (Object)this.eprBuilder.getAddress((Object)this.endpoint));
            template.setAttribute("set", (Object)set);
            template.setAttribute("latest", (Object)RawSet.newInstance());
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).registerProfile(template.toString());
        }
        catch (ISRegistryException e) {
            throw new ActionManagerException("Error registering set " + set, (Throwable)e);
        }
    }

    public List<ActionManagerSet> listSets() {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return $x";
        SAXReader reader = new SAXReader();
        ArrayList list = Lists.newArrayList();
        try {
            for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return $x")) {
                ActionManagerSet set = new ActionManagerSet();
                try {
                    Document doc = reader.read((Reader)new StringReader(s));
                    set.setId(doc.valueOf("//SET/@id").trim());
                    set.setName(doc.valueOf("//SET").trim());
                    set.setImpact(ActionManagerSet.ImpactTypes.valueOf((String)doc.valueOf("//IMPACT").trim()));
                    set.setLatest(doc.valueOf("//RAW_SETS/LATEST/@id"), doc.valueOf("//RAW_SETS/LATEST/@creationDate"), doc.valueOf("//RAW_SETS/LATEST/@lastUpdate"));
                    list.add(set);
                }
                catch (Exception e) {
                    log.error((Object)("Error creating set from profile: " + s));
                }
            }
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error accessing Sets, using query: for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return $x");
        }
        return list;
    }

    public boolean deleteSetProfile(String setId) throws ActionManagerException {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + setId + "' return $x//RESOURCE_IDENTIFIER/@value/string()";
        try {
            String profId = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(q);
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).deleteProfile(profId);
        }
        catch (Exception e) {
            log.error((Object)("Error deleting set " + setId), (Throwable)e);
            throw new ActionManagerException("Error deleting set " + setId, (Throwable)e);
        }
    }

    public boolean existsSet(String id) throws ActionManagerException {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + id + "' return $x";
        try {
            return !((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(q).isEmpty();
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error accessing Sets, using query: " + q), (Throwable)e);
            throw new ActionManagerException("Error running xquery: " + q, (Throwable)e);
        }
    }

    public boolean existsRawSet(String id) throws ActionManagerException {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//RAW_SETS/*/@id = '" + id + "' return $x";
        try {
            return !((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(q).isEmpty();
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error accessing RawSets, using query: " + q), (Throwable)e);
            throw new ActionManagerException("Error running xquery: " + q, (Throwable)e);
        }
    }

    public Set<String> listValidRawSets() throws ActionManagerException {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return $x//RAW_SETS/LATEST/@id/string()";
        try {
            List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return $x//RAW_SETS/LATEST/@id/string()");
            return Sets.newHashSet((Iterable)list);
        }
        catch (Exception e) {
            log.error((Object)"Error running xquery: for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return $x//RAW_SETS/LATEST/@id/string()", (Throwable)e);
            throw new ActionManagerException("Error running xquery: for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return $x//RAW_SETS/LATEST/@id/string()", (Throwable)e);
        }
    }

    public RawSet geLatestRawSet(String set) throws ActionManagerException {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + set + "' return concat(' ' , $x//RAW_SETS/LATEST/@id, ' @@@ ', $x//RAW_SETS/LATEST/@creationDate, ' @@@ ', $x//RAW_SETS/LATEST/@lastUpdate, ' ')";
        try {
            String[] arr = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(q).split("@@@");
            return RawSet.newInstance((String)arr[0].trim(), (String)arr[1].trim(), (String)arr[2].trim());
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error accessing Sets, using query: " + q), (Throwable)e);
            throw new ActionManagerException("Error running xquery: " + q, (Throwable)e);
        }
    }

    public String getGarbageTimeMargin() throws ActionManagerException {
        return this.queryServiceProperty("garbageTimeMargin");
    }

    private String queryServiceProperty(String propertyName) throws ActionManagerException {
        String q = "for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ActionManagerServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + propertyName + "']/@value/string()";
        log.debug((Object)("quering for service property: " + q));
        try {
            List value = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(q);
            return (String)Iterables.getOnlyElement((Iterable)value);
        }
        catch (ISLookUpException e) {
            String msg = "Error accessing service profile, using query: " + q;
            log.error((Object)msg, (Throwable)e);
            throw new ActionManagerException(msg, (Throwable)e);
        }
        catch (NoSuchElementException e) {
            String msg = "missing service property: " + propertyName;
            log.error((Object)msg, (Throwable)e);
            throw new ActionManagerException(msg, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String msg = "found more than one service property: " + propertyName;
            log.error((Object)msg, (Throwable)e);
            throw new ActionManagerException(msg, (Throwable)e);
        }
    }

    public void addLatestRawSet(String set, RawSet rawSet) throws ActionManagerException {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + set + "' return $x";
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(q);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            String profId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
            Element latest = (Element)doc.selectSingleNode("//RAW_SETS/LATEST");
            Element expired = ((Element)doc.selectSingleNode("//RAW_SETS")).addElement("EXPIRED");
            for (Object o : latest.attributes()) {
                Attribute a = (Attribute)o;
                expired.addAttribute(a.getName(), a.getValue());
            }
            latest.addAttribute("id", rawSet.getId());
            latest.addAttribute("creationDate", rawSet.getCreationDate());
            latest.addAttribute("lastUpdate", rawSet.getLastUpdate());
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(profId, doc.asXML(), "ActionManagerSetDSResourceType");
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile of set: " + set));
            throw new ActionManagerException("Error running xquery: " + q, (Throwable)e);
        }
    }

    public void updateLastUpdate(String rawSet) throws ActionManagerException {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType')//RAW_SETS/*[@id='" + rawSet + "']/@lastUpdate return update replace $x with '" + DateUtils.now_ISO8601() + "'";
        try {
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(q);
        }
        catch (Exception e) {
            log.error((Object)("Error updating lastUpdate using query: " + q), (Throwable)e);
            throw new ActionManagerException("Error updating lastUpdate using query: " + q, (Throwable)e);
        }
    }

    public StringTemplate getActionManagerSetDsTemplate() {
        return this.actionManagerSetDsTemplate;
    }

    @Required
    public void setActionManagerSetDsTemplate(StringTemplate actionManagerSetDsTemplate) {
        this.actionManagerSetDsTemplate = actionManagerSetDsTemplate;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Required
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    @Required
    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }
}

