/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.hbase;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.data.hadoop.HadoopServiceCore;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Required;

public class HBaseClient {
    private String tableName;
    private static final Log log = LogFactory.getLog(HBaseClient.class);
    private final Executor executor = Executors.newSingleThreadExecutor();
    private static final int DEFAULT_START_DELAY = 60000;
    private int startDelay = 60000;
    @Resource
    private HadoopServiceCore hadoopServiceCore;
    private final Function<Result, Map<String, String>> transformRow = new Function<Result, Map<String, String>>(){

        public Map<String, String> apply(Result r) {
            HashMap map = Maps.newHashMap();
            map.put("rowId", Bytes.toString((byte[])r.getRow()));
            for (Map.Entry e1 : r.getMap().entrySet()) {
                String cf = Bytes.toString((byte[])((byte[])e1.getKey()));
                for (Map.Entry e2 : ((NavigableMap)e1.getValue()).entrySet()) {
                    byte[] bb = (byte[])((NavigableMap)e2.getValue()).get(Collections.max(((NavigableMap)e2.getValue()).keySet()));
                    String key = cf + ":" + Bytes.toString((byte[])((byte[])e2.getKey()));
                    String value = "";
                    try {
                        value = key.equals("target:content") ? OafProtos.Oaf.parseFrom((byte[])bb).toString() : Bytes.toString((byte[])bb);
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.error((Object)"Problem parsing protobuf !!!");
                    }
                    map.put(key, value);
                }
            }
            return map;
        }
    };

    public void init() {
        this.performInit(false);
    }

    public void initWithEmptyTable() {
        this.performInit(true);
    }

    private void performInit(final boolean delete) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(HBaseClient.this.getStartDelay());
                    log.info((Object)"Initializing Action Manager");
                    HBaseClient.this.prepareTable(delete);
                    log.info((Object)"ActionManager is ready");
                }
                catch (Exception e) {
                    log.error((Object)"Error initializing action manager", (Throwable)e);
                }
            }
        });
    }

    private void prepareTable(boolean delete) throws HadoopServiceException, IOException {
        HashSet<String> columns = new HashSet<String>();
        for (ActionManagerConstants.COLUMN_FAMILIES cf : ActionManagerConstants.COLUMN_FAMILIES.values()) {
            columns.add(cf.toString());
        }
        if (delete) {
            this.hadoopServiceCore.truncateTable(ClusterName.DM, this.tableName);
        }
        this.hadoopServiceCore.ensureTable(ClusterName.DM, this.tableName, columns);
    }

    public void write(List<Put> puts) throws ActionManagerException {
        try {
            log.info((Object)("Adding " + puts.size() + " action(s) to " + this.tableName));
            this.hadoopServiceCore.write(ClusterName.DM, this.tableName, puts);
            log.info((Object)("Number of action written: " + puts.size()));
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public void delete(List<Delete> deletes) throws ActionManagerException {
        try {
            log.info((Object)("Deleting " + deletes.size() + " action(s) from " + this.tableName));
            this.hadoopServiceCore.delete(ClusterName.DM, this.tableName, deletes);
            log.info((Object)("Number of action deleted: " + deletes.size()));
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public Map<String, String> getRow(byte[] id) throws ActionManagerException {
        try {
            Result result = this.hadoopServiceCore.getRow(ClusterName.DM, this.tableName, id);
            return (Map)this.transformRow.apply((Object)result);
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public List<Map<String, String>> retrieveRows(String prefix, String start, int limit) throws ActionManagerException {
        try {
            PageFilter filter = prefix == null || prefix.isEmpty() ? new PageFilter((long)limit) : new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{new PageFilter((long)limit), new PrefixFilter(Bytes.toBytes((String)prefix))});
            Scan scan = new Scan();
            if (start != null) {
                scan.setStartRow(Bytes.toBytes((String)start));
            }
            scan.setFilter((Filter)filter);
            return Lists.transform((List)this.hadoopServiceCore.getRows(ClusterName.DM, this.tableName, scan), this.transformRow);
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public List<String> retrieveActionsByAgent(String agentId, int limit) throws ActionManagerException {
        try {
            String prefix = ActionManagerConstants.ACTION_TYPE.pkg + "|" + Hashing.md5().hashString((CharSequence)agentId) + "|";
            FilterList filter = new FilterList(FilterList.Operator.MUST_PASS_ALL);
            filter.addFilter((Filter)new PageFilter((long)limit));
            filter.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)prefix)));
            Scan scan = new Scan();
            scan.setFilter((Filter)filter);
            ArrayList list = Lists.newArrayList();
            for (Result r : this.hadoopServiceCore.getRows(ClusterName.DM, this.tableName, scan)) {
                HashMap map = Maps.newHashMap();
                map.put("id", Bytes.toString((byte[])r.getRow()));
                map.put("content", Bytes.toString((byte[])r.getValue(ActionManagerConstants.ACTION_COLFAMILY, Bytes.toBytes((String)ActionManagerConstants.ACTION_TYPE.pkg.toString()))));
                list.add(new Gson().toJson((Object)map));
            }
            return list;
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    @Required
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }
}

