/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.hbase;

import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.XsltInfoPackageAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBaseClient;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Required;

public class HBaseActionManagerCore {
    private ActionFactory actionFactory;
    private HBaseClient hbaseClient;
    private ISClient informationServiceClient;

    public XsltInfoPackageAction applyInfoPackageAction(String splitRuleId, String set, Agent agent, Operation operation, String infoPackage, Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        if (this.informationServiceClient.existsSet(set)) {
            RawSet rawSet = this.informationServiceClient.geLatestRawSet(set);
            XsltInfoPackageAction action = this.bulkApplyInfoPackageAction(splitRuleId, rawSet, agent, operation, infoPackage, provenance, trust, nsprefix);
            if (this.informationServiceClient.existsRawSet(rawSet.getId())) {
                this.informationServiceClient.updateLastUpdate(rawSet.getId());
            } else {
                rawSet.setLastUpdate(DateUtils.now_ISO8601());
                this.informationServiceClient.addLatestRawSet(set, rawSet);
            }
            return action;
        }
        throw new ActionManagerException("Missing set " + set);
    }

    public XsltInfoPackageAction bulkApplyInfoPackageAction(String splitRuleId, RawSet rawSet, Agent agent, Operation operation, String infoPackage, Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        XsltInfoPackageAction action = this.actionFactory.generateInfoPackageAction(splitRuleId, rawSet.getId(), agent, operation, infoPackage, provenance, nsprefix, trust);
        List puts = action.asPutOperations();
        this.hbaseClient.write(puts);
        return action;
    }

    public void deleteInfoPackageAction(String id) throws ActionManagerException {
        Map<String, String> row = this.hbaseClient.getRow(Bytes.toBytes((String)id));
        ArrayList deletes = Lists.newArrayList();
        String rawSet = null;
        for (String key : row.keySet()) {
            if (key.startsWith("rel:")) {
                deletes.add(new Delete(Bytes.toBytes((String)key.substring(4))));
                continue;
            }
            if (!key.startsWith("set:")) continue;
            rawSet = key.substring(4);
        }
        deletes.add(new Delete(Bytes.toBytes((String)id)));
        if (rawSet != null) {
            this.informationServiceClient.updateLastUpdate(rawSet);
        }
        this.hbaseClient.delete(deletes);
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    @Required
    public void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public HBaseClient getHbaseClient() {
        return this.hbaseClient;
    }

    @Required
    public void setHbaseClient(HBaseClient hbaseClient) {
        this.hbaseClient = hbaseClient;
    }

    public List<ActionManagerSet> listAvailableSets() {
        return this.informationServiceClient.listSets();
    }

    public ISClient getInformationServiceClient() {
        return this.informationServiceClient;
    }

    @Required
    public void setInformationServiceClient(ISClient informationServiceClient) {
        this.informationServiceClient = informationServiceClient;
    }
}

