package eu.dnetlib.openaire.exporter;

import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectQueryParams {

	private String fundingProgramme = null;
	/** Whatever is following the fundingProgramme **/
	private String fundingPath = null;

	private String startFrom = null;
	private String startUntil = null;
	private String endFrom = null;
	private String endUntil = null;

	private static final Log log = LogFactory.getLog(ProjectQueryParams.class); // NOPMD by marko on 11/24/08 5:02 PM

	public String getFundingProgramme() {
		return fundingProgramme;
	}

	public void setFundingProgramme(final String fundingProgramme) {
		this.fundingProgramme = verifyParam(fundingProgramme);
	}

	public String getFundingPath() {
		return fundingPath;
	}

	public void setFundingPath(final String fundingPath) {
		this.fundingPath = verifyParam(fundingPath);
	}

	public String getStartFrom() {
		return startFrom;
	}

	public void setStartFrom(final String startFrom) {
		this.startFrom = verifyDateParam(startFrom);
	}

	public String getStartUntil() {
		return startUntil;
	}

	public void setStartUntil(final String startUntil) {
		this.startUntil = verifyDateParam(startUntil);
	}

	public String getEndFrom() {
		return endFrom;
	}

	public void setEndFrom(final String endFrom) {
		this.endFrom = verifyDateParam(endFrom);
	}

	public String getEndUntil() {
		return endUntil;
	}

	public void setEndUntil(final String endUntil) {
		this.endUntil = verifyDateParam(endUntil);
	}

	protected String verifyParam(final String p) {
		Pattern pattern = Pattern.compile("(\\w*(::|%| )*)*");
		log.debug("TESTING SQL PARAM: " + p);
		if ((p != null) && !pattern.matcher(p).matches()) throw new IllegalArgumentException("Parameter contains an invalid character");
		log.debug("TEST OK");
		return p;
	}

	protected String verifyDateParam(final String date){
		Pattern pattern = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d");
		log.debug("TESTING SQL DATE PARAM: " + date);
		if ((date != null) && !pattern.matcher(date).matches()) throw new IllegalArgumentException("Parameter date contains an invalid character. Accepted pattern is "+pattern.toString());
		log.debug("TEST OK");
		return date;

	}
}
