/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.maps.ConcurrentSizedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;

public class MongoResultSetListener
implements ResultSetListener,
ResultSetAware {
    private static final Log log = LogFactory.getLog(MongoResultSetListener.class);
    private ConcurrentSizedMap<Integer, String> lastKeys = new ConcurrentSizedMap();
    private Bson sortByIdAsc = Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"id"})});
    private Function<DBObject, String> serializer;
    private Pattern filter;
    private MongoCollection<DBObject> collection;

    public MongoResultSetListener(MongoCollection<DBObject> collection, Pattern filter, Function<DBObject, String> serializer) {
        this.collection = collection;
        this.filter = filter;
        this.serializer = serializer;
    }

    public List<String> getResult(int fromPosition, int toPosition) {
        ArrayList<DBObject> page = null;
        String lastKey = (String)this.lastKeys.get((Object)fromPosition);
        page = lastKey != null ? this.continueFrom(lastKey, toPosition - fromPosition + 1) : this.fetchNew(fromPosition - 1, toPosition - fromPosition + 1);
        if (!page.isEmpty()) {
            DBObject last = page.get(page.size() - 1);
            this.lastKeys.put((Object)(toPosition + 1), (Object)((String)last.get("id")));
        }
        if (log.isDebugEnabled()) {
            log.info((Object)String.format("got %s records from %s to %s", page.size(), fromPosition, toPosition));
        }
        return Lists.newArrayList((Iterable)Iterables.transform(page, this.serializer));
    }

    private ArrayList<DBObject> fetchNew(int from, int size) {
        FindIterable it = null;
        if (this.filter != null) {
            Bson query = Filters.regex((String)"body", (Pattern)this.filter);
            it = this.collection.find(query);
        } else {
            it = this.collection.find();
        }
        return Lists.newArrayList((Iterable)it.sort(this.sortByIdAsc).skip(from).limit(size));
    }

    private ArrayList<DBObject> continueFrom(String lastKey, int size) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to continue from previous key: " + lastKey));
        }
        Bson filterQuery = Filters.gt((String)"id", (Object)lastKey);
        if (this.filter != null) {
            filterQuery = Filters.and((Bson[])new Bson[]{filterQuery, Filters.regex((String)"body", (Pattern)this.filter)});
        }
        FindIterable it = this.collection.find(filterQuery).sort(this.sortByIdAsc).limit(size);
        return Lists.newArrayList((Iterable)it);
    }

    public int getSize() {
        if (this.filter != null) {
            BasicDBObject query = (BasicDBObject)QueryBuilder.start((String)"body").regex(this.filter).get();
            return (int)this.collection.count((Bson)query);
        }
        return (int)this.collection.count();
    }

    public void setResultSet(ResultSet resultSet) {
        resultSet.close();
    }
}

