/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreExpiredInfo;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreManagerInfo;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreTransactionInfo;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreTransactionManager;
import eu.dnetlib.data.mdstore.modular.mongodb.utils.MDStoreUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreTransactionManagerImpl
implements MDStoreTransactionManager {
    private static final Log log = LogFactory.getLog(MDStoreTransactionManagerImpl.class);
    private static String TABLE_NAME = "metadataManager";
    private int maxTransactions = 1;
    private MongoDatabase db;
    private MongoCollection<DBObject> managerTable;
    private int expiredDays;

    private void bootstrapManager() {
        log.debug((Object)"Bootstrap Manager start");
        MongoCollection metadataColl = this.db.getCollection("metadata", DBObject.class);
        FindIterable values = metadataColl.find();
        this.setManagerTable((MongoCollection<DBObject>)this.db.getCollection(TABLE_NAME, DBObject.class));
        for (DBObject object : values) {
            String id;
            String newId = id = (String)object.get("mdId");
            if (id.contains("_")) {
                newId = StringUtils.substringBefore((String)id, (String)"_");
            }
            BasicDBObject input = new BasicDBObject();
            input.put((Object)"mdId", (Object)id);
            input.put((Object)"currentId", (Object)newId);
            input.put((Object)"expiring", (Object)new String[0]);
            input.put((Object)"transactions", (Object)new String[0]);
            this.getManagerTable().insertOne((Object)input);
            log.debug((Object)String.format("Added %s to Metadata Manager data structure", id));
        }
        BasicDBObject ensureIndex = new BasicDBObject();
        ensureIndex.put((Object)"mdId", (Object)1);
        log.debug((Object)"Create index in MetadaManager ");
        this.getManagerTable().createIndex((Bson)ensureIndex);
    }

    private DBObject getMDStoreAsDBObject(String mdstoreID) throws MDStoreServiceException {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"mdId", (Object)mdstoreID);
        FindIterable it = this.getManagerTable().find((Bson)query);
        DBObject mdstoreInfo = (DBObject)it.first();
        return mdstoreInfo;
    }

    public void verifyConsistency() throws MDStoreServiceException {
        if (this.getManagerTable() == null) {
            if (!Lists.newArrayList((Iterable)this.db.listCollectionNames()).contains(TABLE_NAME)) {
                this.bootstrapManager();
            } else {
                this.setManagerTable((MongoCollection<DBObject>)this.db.getCollection(TABLE_NAME, DBObject.class));
            }
        }
        if (this.getManagerTable() == null) {
            throw new MDStoreServiceException("Something bad happen, unable to create managerTable");
        }
    }

    public void createMDStore(String mdId) throws MDStoreServiceException {
        log.debug((Object)"Creating new mdstore");
        this.verifyConsistency();
        String newId = mdId;
        if (mdId.contains("_")) {
            newId = StringUtils.substringBefore((String)mdId, (String)"_");
        }
        BasicDBObject instance = new BasicDBObject();
        instance.put((Object)"mdId", (Object)mdId);
        instance.put((Object)"currentId", (Object)newId);
        instance.put((Object)"expiring", (Object)new String[0]);
        this.getManagerTable().insertOne((Object)instance);
    }

    public void dropMDStore(String mdId) throws MDStoreServiceException {
        this.verifyConsistency();
        log.debug((Object)("Droping MDStore: " + mdId));
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"mdId", (Object)mdId);
        DBObject dropped = (DBObject)this.getManagerTable().findOneAndDelete((Bson)query);
        this.garbage();
        String collectionName = (String)dropped.get("currentId");
        this.db.getCollection(collectionName).drop();
        this.db.getCollection("discarded-" + collectionName).drop();
    }

    public String getMDStoreCollection(String mdId) throws MDStoreServiceException {
        this.verifyConsistency();
        DBObject mdstoreInfo = this.getMDStoreAsDBObject(mdId);
        if (mdstoreInfo != null) {
            return (String)mdstoreInfo.get("currentId");
        }
        return null;
    }

    public String startTransaction(String mdId, boolean refresh) throws MDStoreServiceException {
        BasicDBList values;
        this.verifyConsistency();
        log.info((Object)("Start transaction for metadata store " + mdId));
        DBObject mdstoreInfo = this.getMDStoreAsDBObject(mdId);
        if (mdstoreInfo == null) {
            throw new MDStoreServiceException("Error, unable to find Mdstore with Id " + mdId);
        }
        String idCreation = StringUtils.substringBefore((String)mdId, (String)"_");
        idCreation = idCreation + "::" + System.currentTimeMillis();
        if (mdstoreInfo.containsField("transactions")) {
            values = (BasicDBList)mdstoreInfo.get("transactions");
            if (values.size() > this.getMaxTransactions()) {
                throw new MDStoreServiceException("Cannot create more than " + this.getMaxTransactions() + " transactions, found: " + values.size() + ", mdId:" + mdId);
            }
        } else {
            values = new BasicDBList();
        }
        BasicDBObject transactionMetadata = new BasicDBObject();
        transactionMetadata.put((Object)"id", (Object)idCreation.toString());
        transactionMetadata.put((Object)"refresh", (Object)refresh);
        transactionMetadata.put((Object)"date", (Object)new Date());
        values.add((Object)transactionMetadata);
        mdstoreInfo.put("transactions", (Object)values);
        this.getManagerTable().findOneAndReplace((Bson)new BasicDBObject("_id", mdstoreInfo.get("_id")), (Object)mdstoreInfo);
        return idCreation.toString();
    }

    public boolean commit(String transactionId, String mdstoreId, MDStore current) throws MDStoreServiceException {
        this.verifyConsistency();
        DBObject mdstoreInfo = this.getMDStoreAsDBObject(mdstoreId);
        if (mdstoreInfo == null) {
            throw new MDStoreServiceException("Error, unable to find Mdstore with Id " + mdstoreId);
        }
        BasicDBList transactions = (BasicDBList)mdstoreInfo.get("transactions");
        DBObject transaction = this.findTransaction(transactions, transactionId);
        if (transaction == null) {
            throw new MDStoreServiceException("Error, unable to find transaction with Id " + transactionId);
        }
        boolean refresh = (Boolean)transaction.get("refresh");
        transactions.remove((Object)transaction);
        String oldId = (String)mdstoreInfo.get("currentId");
        if (refresh) {
            mdstoreInfo.put("currentId", (Object)transactionId);
            BasicDBList stillUsed = (BasicDBList)mdstoreInfo.get("expiring");
            if (stillUsed.size() == 0) {
                this.db.getCollection(oldId).drop();
                this.db.getCollection("discarded-" + oldId).drop();
            }
            log.debug((Object)"Replaced collection ");
        } else {
            log.debug((Object)"commit incremental ");
            this.updateIncremental(transactionId, oldId);
            this.db.getCollection(transactionId).drop();
            this.db.getCollection("discarded-" + transactionId).drop();
        }
        this.getManagerTable().findOneAndReplace((Bson)new BasicDBObject("_id", mdstoreInfo.get("_id")), (Object)mdstoreInfo);
        log.info((Object)("Committed transaction for metadata store " + mdstoreId));
        return true;
    }

    private DBObject findTransaction(BasicDBList transactions, String transactionId) {
        if (transactions.size() == 0) {
            return null;
        }
        for (int i = 0; i < transactions.size(); ++i) {
            BasicDBObject transaction = (BasicDBObject)transactions.get(i);
            String id = (String)transaction.get("id");
            if (!transactionId.equals(id)) continue;
            return transaction;
        }
        return null;
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    @Required
    public void setDb(MongoDatabase db) {
        this.db = db;
    }

    public String readMdStore(String mdStoreId) throws MDStoreServiceException {
        this.verifyConsistency();
        DBObject mdstoreInfo = this.getMDStoreAsDBObject(mdStoreId);
        if (mdstoreInfo == null) {
            throw new MDStoreServiceException("Error, unable to find Mdstore with Id " + mdStoreId);
        }
        String currentId = (String)mdstoreInfo.get("currentId");
        BasicDBList values = (BasicDBList)mdstoreInfo.get("expiring");
        this.updateMdstoreUsed(values, currentId);
        this.getManagerTable().findOneAndReplace((Bson)new BasicDBObject("_id", mdstoreInfo.get("_id")), (Object)mdstoreInfo);
        return currentId;
    }

    private void updateMdstoreUsed(BasicDBList values, String mdId) {
        if (values.size() > 0) {
            for (int i = 0; i < values.size(); ++i) {
                DBObject obj = (DBObject)values.get(i);
                String id = (String)obj.get("id");
                if (!mdId.equals(id)) continue;
                obj.put("lastRead", (Object)new Date());
                return;
            }
        }
        BasicDBObject readStore = new BasicDBObject();
        readStore.put((Object)"id", (Object)mdId);
        readStore.put((Object)"lastRead", (Object)new Date());
        values.add((Object)readStore);
    }

    public MongoCollection<DBObject> getManagerTable() {
        return this.managerTable;
    }

    public void setManagerTable(MongoCollection<DBObject> managerTable) {
        this.managerTable = managerTable;
    }

    public MDStoreManagerInfo getInfoForCurrentMdStore(String mdStoreId) throws MDStoreServiceException {
        this.verifyConsistency();
        DBObject mdstoreInfo = this.getMDStoreAsDBObject(mdStoreId);
        if (mdstoreInfo == null) {
            throw new MDStoreServiceException("Error, unable to find Mdstore with Id " + mdStoreId);
        }
        MDStoreManagerInfo result = new MDStoreManagerInfo();
        result.setCurrentId((String)mdstoreInfo.get("currentId"));
        result.setMdId((String)mdstoreInfo.get("mdId"));
        BasicDBList values = (BasicDBList)mdstoreInfo.get("expiring");
        for (int i = 0; i < values.size(); ++i) {
            MDStoreExpiredInfo stillused = new MDStoreExpiredInfo();
            DBObject value = (DBObject)values.get(i);
            stillused.setId((String)value.get("id"));
            stillused.setLastRead((Date)value.get("lastRead"));
            result.addExpiredItem(stillused);
        }
        BasicDBList transactions = (BasicDBList)mdstoreInfo.get("transactions");
        if (transactions != null) {
            for (int i = 0; i < transactions.size(); ++i) {
                MDStoreTransactionInfo transaction = new MDStoreTransactionInfo();
                DBObject value = (DBObject)transactions.get(i);
                String transactionId = (String)value.get("id");
                transaction.setId(transactionId);
                transaction.setDate((Date)value.get("date"));
                transaction.setRefresh((Boolean)value.get("refresh"));
                transaction.setSize(this.db.getCollection(transactionId).count());
                result.addTransactionInfo(transaction);
            }
        }
        return result;
    }

    public Boolean dropUsed(String mdId, String idToDrop) throws MDStoreServiceException {
        this.verifyConsistency();
        DBObject mdstoreInfo = this.getMDStoreAsDBObject(mdId);
        if (mdstoreInfo == null) {
            throw new MDStoreServiceException("Error, unable to find Mdstore with Id " + mdId);
        }
        return this.dropStore(mdstoreInfo, idToDrop, "expiring");
    }

    private boolean dropStore(DBObject mdstoreInfo, String idToDrop, String transactionListName) throws MDStoreServiceException {
        BasicDBList transactionList = (BasicDBList)mdstoreInfo.get(transactionListName);
        for (int i = 0; i < transactionList.size(); ++i) {
            DBObject value = (DBObject)transactionList.get(i);
            String currentUsedId = (String)value.get("id");
            if (!currentUsedId.equals(idToDrop)) continue;
            this.db.getCollection(idToDrop).drop();
            this.db.getCollection("discarded-" + idToDrop).drop();
            transactionList.remove((Object)value);
            mdstoreInfo.put(transactionListName, (Object)transactionList);
            this.getManagerTable().findOneAndReplace((Bson)new BasicDBObject("_id", mdstoreInfo.get("_id")), (Object)mdstoreInfo);
            return true;
        }
        throw new MDStoreServiceException("Error, unable to drop collection " + idToDrop);
    }

    public void garbage() throws MDStoreServiceException {
        this.verifyConsistency();
        log.info((Object)"Start garbage collection of MdStore");
        FindIterable it = this.managerTable.find();
        int totalDeleted = 0;
        for (DBObject currentObject : it) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("start to check id: " + currentObject.get("currentId")));
            }
            this.garbageExpiring(currentObject, (String)currentObject.get("currentId"));
            this.garbageTransactions(currentObject, (String)currentObject.get("currentId"));
            this.getManagerTable().findOneAndReplace((Bson)new BasicDBObject("_id", currentObject.get("_id")), (Object)currentObject);
        }
        MongoIterable collections = this.db.listCollectionNames();
        for (String collection : collections) {
            DBObject item;
            if (collection.length() <= 30 || collection.contains("discarded-") || !this.shouldDelete(collection, item = this.getMetadataObjectForCollections(collection))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("delete collection: " + collection + " from mongo"));
            }
            this.db.getCollection(collection).drop();
            this.db.getCollection("discarded-" + collection).drop();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("delete collection: discarded-" + collection + " from mongo"));
        }
        log.info((Object)("Complete garbage collection of MdStore, total store deleted: " + totalDeleted));
    }

    private DBObject getMetadataObjectForCollections(String collectionName) {
        if (collectionName == null) {
            return null;
        }
        String postfix = "_TURTdG9yZURTUmVzb3VyY2VzL01EU3RvcmVEU1Jlc291cmNlVHlwZQ==";
        String tmp = collectionName.contains("discarded-") ? StringUtils.substringAfter((String)collectionName, (String)"discarded-") : collectionName;
        String collectionNameCleaned = StringUtils.substringBefore((String)tmp, (String)"::") + "_TURTdG9yZURTUmVzb3VyY2VzL01EU3RvcmVEU1Jlc291cmNlVHlwZQ==";
        Bson query = Filters.eq((String)"mdId", (Object)collectionNameCleaned);
        return (DBObject)this.managerTable.find(query).first();
    }

    private boolean shouldDelete(String collectionName, DBObject metadataManagerInstance) {
        log.debug((Object)("should delete instance " + metadataManagerInstance));
        if (metadataManagerInstance == null || metadataManagerInstance.get("currentId") == null) {
            log.debug((Object)"the instance has not currentID");
            return true;
        }
        String currentId = (String)metadataManagerInstance.get("currentId");
        if (collectionName.equals(currentId)) {
            return false;
        }
        BasicDBList expiringList = (BasicDBList)metadataManagerInstance.get("expiring");
        if (this.findInList(expiringList, collectionName, "id")) {
            return false;
        }
        BasicDBList transactionsList = (BasicDBList)metadataManagerInstance.get("transactions");
        return !this.findInList(transactionsList, collectionName, "id");
    }

    private boolean findInList(BasicDBList list, String object, String tagname) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            DBObject currentObject = (DBObject)list.get(i);
            String id = (String)currentObject.get(tagname);
            if (!id.equals(object)) continue;
            return true;
        }
        return false;
    }

    private void delete(BasicDBList list, List<DBObject> toRemove) {
        for (DBObject obj : toRemove) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleting " + obj));
            }
            list.remove((Object)obj);
        }
    }

    private void garbageTransactions(DBObject currentObject, String currentId) {
        BasicDBList expiring;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start garbage transactions ");
        }
        if ((expiring = (BasicDBList)currentObject.get("transactions")) == null || expiring.size() <= this.getMaxTransactions()) {
            return;
        }
        ArrayList expiringList = Lists.newArrayList();
        for (int i = 0; i < expiring.size(); ++i) {
            DBObject cobj = (DBObject)expiring.get(i);
            if (cobj == null) continue;
            expiringList.add((DBObject)expiring.get(i));
        }
        Collections.sort(expiringList, MDStoreUtils.getComparatorOnDate());
        ArrayList toRemove = Lists.newArrayList();
        int i = 0;
        while (expiringList.size() - toRemove.size() > this.getMaxTransactions() || i < expiringList.size()) {
            DBObject currentObj;
            String objectId;
            if (!(objectId = (String)(currentObj = (DBObject)expiringList.get(i++)).get("id")).equals(currentId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("delete collection: " + objectId + " from mongo"));
                }
                this.db.getCollection(objectId).drop();
                this.db.getCollection("discarded-" + objectId).drop();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("delete collection: discarded-" + objectId + " from mongo"));
                }
                toRemove.add(currentObj);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Cannot remove transaction " + objectId + " because is the currentId: " + currentId));
        }
        this.delete(expiring, toRemove);
        log.info((Object)("Deleted " + toRemove.size() + " transactions, mdStore Id:" + currentObject.get("mdId")));
    }

    private void garbageExpiring(DBObject currentObject, String currentId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start to search expiring mdstores for id: " + currentObject.get("mdId")));
        }
        BasicDBList expiring = (BasicDBList)currentObject.get("expiring");
        ArrayList toRemove = Lists.newArrayList();
        if (log.isDebugEnabled()) {
            if (expiring == null) {
                log.debug((Object)"expiring list is null");
            } else {
                log.debug((Object)("expiring list size is :" + expiring.size()));
            }
        }
        if (expiring == null || expiring.size() == 0) {
            log.debug((Object)("Deleted  0  expired  collections, mdStore Id:" + currentObject.get("mdId")));
            return;
        }
        for (int i = 0; i < expiring.size(); ++i) {
            DBObject currentExpiredStore = (DBObject)expiring.get(i);
            String currentUsedId = (String)currentExpiredStore.get("id");
            Days d = this.getExpiringDays(currentExpiredStore, "lastRead");
            if (log.isDebugEnabled()) {
                log.debug((Object)("the store :" + currentId + " expired since " + d.getDays() + "days "));
            }
            if (d.getDays() <= this.getExpiredDays()) continue;
            if (!currentUsedId.equals(currentId)) {
                this.db.getCollection(currentUsedId).drop();
                this.db.getCollection("discarded-" + currentUsedId).drop();
                log.debug((Object)("deleted collection " + currentUsedId));
            }
            toRemove.add(currentExpiredStore);
        }
        this.delete(expiring, toRemove);
        log.debug((Object)("Deleted expired " + toRemove.size() + "collections, mdStore Id:" + currentObject.get("mdId")));
    }

    private Days getExpiringDays(DBObject value, String paramName) {
        Date lastRead = (Date)value.get(paramName);
        DateTime last = new DateTime((Object)lastRead);
        DateTime today = new DateTime();
        Days d = Days.daysBetween((ReadableInstant)last, (ReadableInstant)today);
        return d;
    }

    public int getExpiredDays() {
        if (this.expiredDays == 0) {
            return 3;
        }
        return this.expiredDays;
    }

    public void setExpiredDays(int expiredDays) {
        this.expiredDays = expiredDays;
    }

    private void updateIncremental(String transactionId, String currentId) {
        MongoCollection transaction = this.db.getCollection(transactionId, DBObject.class);
        MongoCollection mdstore = this.db.getCollection(currentId, DBObject.class);
        FindIterable it = transaction.find();
        for (DBObject currentObj : it) {
            BasicDBObject newObj = new BasicDBObject();
            String id = (String)currentObj.get("id");
            String body = (String)currentObj.get("body");
            newObj.put((Object)"id", (Object)id);
            newObj.put((Object)"body", (Object)body);
            if (!StringUtils.isNotBlank((String)id)) continue;
            MongoCollection mdstoreWrite = mdstore.withWriteConcern(WriteConcern.JOURNALED);
            mdstoreWrite.replaceOne((Bson)new BasicDBObject("id", (Object)id), (Object)newObj, new UpdateOptions().upsert(true));
        }
    }

    public Boolean dropTransaction(String mdId, String idToDrop) throws MDStoreServiceException {
        this.verifyConsistency();
        DBObject mdstoreInfo = this.getMDStoreAsDBObject(mdId);
        if (mdstoreInfo == null) {
            throw new MDStoreServiceException("Error, unable to find Mdstore with Id " + mdId);
        }
        return this.dropStore(mdstoreInfo, idToDrop, "transactions");
    }

    public void garbageTransactionsOnStart() throws MDStoreServiceException {
        this.verifyConsistency();
        FindIterable it = this.managerTable.find();
        for (DBObject currentObject : it) {
            BasicDBList transactions = (BasicDBList)currentObject.get("transactions");
            if (transactions == null || transactions.size() <= 0) continue;
            for (int i = 0; i < transactions.size(); ++i) {
                DBObject currentTransactions = (DBObject)transactions.get(i);
                String id = (String)currentTransactions.get("id");
                this.db.getCollection(id).drop();
                this.db.getCollection("discarded-" + id).drop();
                log.debug((Object)("deleted collection " + id));
            }
            currentObject.put("transactions", (Object)new BasicDBList());
            this.getManagerTable().findOneAndReplace((Bson)new BasicDBObject("_id", currentObject.get("_id")), (Object)currentObject);
        }
    }

    public int getMaxTransactions() {
        return this.maxTransactions;
    }

    public void setMaxTransactions(int maxTransactions) {
        this.maxTransactions = maxTransactions;
    }
}

