/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.modular.RecordParser;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoResultSetListener;
import eu.dnetlib.data.mdstore.modular.mongodb.utils.MDStoreUtils;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BasicBSONObject;
import org.springframework.beans.factory.annotation.Required;

public class MongoMDStore
implements MDStore {
    private static final Log log = LogFactory.getLog(MongoMDStore.class);
    private String id;
    private DBCollection collection;
    private DBCollection discardedCollection;
    private RecordParser recordParser;
    private final boolean upsert;
    private final boolean discardRecords;
    private static List<String> requiredIndicies = Lists.newArrayList((Object[])new String[]{"{ \"id\" : 1}", "{ \"timestamp\" : 1}", "{ \"originalId\" : 1}"});

    public MongoMDStore(String id, DBCollection collection, RecordParser recordParser, boolean upsert, boolean discardRecords) {
        this.id = id;
        this.collection = collection;
        this.discardedCollection = collection.getDB().getCollection("discarded-" + StringUtils.substringBefore((String)id, (String)"_"));
        this.recordParser = recordParser;
        this.upsert = upsert;
        this.discardRecords = discardRecords;
    }

    public int feed(Iterable<String> records, final boolean incremental) {
        this.ensureIndices();
        final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(80);
        final Object sentinel = new Object();
        Thread background = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Object record;
                    while ((record = queue.take()) != sentinel) {
                        MongoMDStore.this.safeFeedRecord((String)record, incremental);
                    }
                }
                catch (InterruptedException e) {
                    log.fatal((Object)"got exception in background thread", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        });
        background.start();
        try {
            log.info((Object)("feeding mdstore " + this.id));
            if (records != null) {
                for (String record : records) {
                    queue.put(record);
                }
            }
            queue.put(sentinel);
            log.info((Object)("finished feeding mdstore " + this.id));
            background.join();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        this.ensureIndices();
        this.collection.ensureIndex((DBObject)new BasicDBObject("id", (Object)1));
        return this.getSize();
    }

    public void ensureIndices() {
        this.collection.resetIndexCache();
        for (String key : Lists.newArrayList((Object[])new String[]{"id", "timestamp", "originalId"})) {
            this.collection.ensureIndex((DBObject)new BasicDBObject(key, (Object)1));
        }
    }

    public boolean isIndexed() {
        return Lists.newArrayList((Iterable)new MappedCollection((Collection)this.collection.getIndexInfo(), (UnaryFunction)new UnaryFunction<String, DBObject>(){

            public String evaluate(DBObject dbo) {
                return new BasicBSONObject(dbo.toMap()).getString("key");
            }
        })).containsAll(requiredIndicies);
    }

    private void safeFeedRecord(String record, boolean incremental) {
        block3: {
            try {
                if (record.isEmpty()) {
                    return;
                }
                this.feedRecord(record, incremental);
            }
            catch (Throwable e) {
                if (!this.discardRecords) break block3;
                log.info((Object)"Got unhandled exception while parsing record", e);
                this.discardedCollection.insert(new DBObject[]{new BasicDBObject("body", (Object)record)});
            }
        }
    }

    private void feedRecord(String record, boolean incremental) {
        Map recordProperties = this.recordParser.parseRecord(record);
        log.debug((Object)("found props: " + recordProperties));
        if (recordProperties.containsKey("id")) {
            BasicDBObject obj = new BasicDBObject();
            String id = (String)recordProperties.get("id");
            String originalId = (String)recordProperties.get("originalId");
            obj.put("id", (Object)id);
            obj.put("originalId", (Object)originalId);
            obj.put("body", (Object)record);
            obj.put("timestamp", (Object)System.currentTimeMillis());
            this.collection.update((DBObject)new BasicDBObject("id", (Object)id), (DBObject)obj, this.upsert, false);
        } else if (this.discardRecords) {
            log.debug((Object)"parsed record seems invalid");
            this.discardedCollection.insert(new DBObject[]{new BasicDBObject("body", (Object)record)});
        }
    }

    public void replace(String grep, String replace) {
        Pattern regex = Pattern.compile(grep, 8);
        DBCursor matches = this.collection.find(QueryBuilder.start((String)"body").regex(regex).get());
        log.debug((Object)("FOUND: " + matches.size()));
        for (DBObject match : matches) {
            BasicDBObject o = new BasicDBObject(match.toMap());
            o.put("body", (Object)regex.matcher((String)match.get("body")).replaceAll(replace));
            this.collection.update(match, (DBObject)o);
        }
    }

    public ResultSetListener deliver(String from, String until, String recordFilter) {
        return this.deliver(from, until, recordFilter, new SerializeMongoRecord());
    }

    public ResultSetListener deliverIds(String from, String until, String recordFilter) {
        return this.deliver(from, until, recordFilter, new SerializeMongoRecordId());
    }

    public ResultSetListener deliver(String from, String until, String recordFilter, UnaryFunction<String, DBObject> serializer) {
        this.ensureIndices();
        Pattern filter = recordFilter != null && recordFilter.length() > 0 ? Pattern.compile(recordFilter, 8) : null;
        return new MongoResultSetListener(this.collection, filter, serializer);
    }

    public Iterable<String> iterate() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Iterators.transform((Iterator)MongoMDStore.this.collection.find(), MDStoreUtils.body());
            }
        };
    }

    public void deleteRecord(String recordId) {
        this.collection.remove((DBObject)new BasicDBObject("id", (Object)recordId));
    }

    public String getRecord(String recordId) throws DocumentNotFoundException {
        DBObject obj = this.collection.findOne((DBObject)new BasicDBObject("id", (Object)recordId));
        if (obj == null || !obj.containsField("body")) {
            throw new DocumentNotFoundException("The document with id " + this.id + " does not exist");
        }
        String body = (String)obj.get("body");
        if (body.trim().length() == 0) {
            throw new DocumentNotFoundException("The document with id " + this.id + " does not exist");
        }
        return new SerializeMongoRecord().evaluate(obj);
    }

    public void truncate() {
        this.collection.drop();
        this.discardedCollection.drop();
    }

    public DBObject getMDStoreMetadata() {
        return this.collection.getDB().getCollection("metadata").findOne((DBObject)new BasicDBObject("mdId", (Object)this.getId()));
    }

    public String getFormat() {
        return (String)this.getMDStoreMetadata().get("format");
    }

    public String getInterpretation() {
        return (String)this.getMDStoreMetadata().get("interpretation");
    }

    public String getLayout() {
        return (String)this.getMDStoreMetadata().get("layout");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    public void setCollection(DBCollection collection) {
        this.collection = collection;
    }

    public RecordParser getRecordParser() {
        return this.recordParser;
    }

    @Required
    public void setRecordParser(RecordParser recordParser) {
        this.recordParser = recordParser;
    }

    public int getSize() {
        return (int)this.collection.getCount();
    }

    public DBCollection getDiscardedCollection() {
        return this.discardedCollection;
    }

    public void setDiscardedCollection(DBCollection discardedCollection) {
        this.discardedCollection = discardedCollection;
    }

    private static final class SerializeMongoRecordId
    implements UnaryFunction<String, DBObject> {
        private SerializeMongoRecordId() {
        }

        public String evaluate(DBObject arg) {
            return (String)arg.get("id");
        }
    }

    private static final class SerializeMongoRecord
    implements UnaryFunction<String, DBObject> {
        private SerializeMongoRecord() {
        }

        public String evaluate(DBObject arg) {
            return (String)arg.get("body");
        }
    }
}

