/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreExpiredInfo;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreManagerInfo;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreTransactionInfo;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreTransactionManager;
import eu.dnetlib.data.mdstore.modular.mongodb.IncrementalIerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreTransactionManagerImpl
implements MDStoreTransactionManager {
    private static final Log log = LogFactory.getLog(MDStoreTransactionManagerImpl.class);
    private static String TABLE_NAME = "metadataManager";
    private DB db;
    private DBCollection managerTable;
    private int expiredDays;
    @Autowired
    private MDStoreDao mdstoreDao;

    private void bootstrapManager() {
        log.debug((Object)"Bootstrap Manager start");
        DBCollection metadataColl = this.db.getCollection("metadata");
        DBCursor values = metadataColl.find();
        this.setManagerTable(this.db.getCollection(TABLE_NAME));
        while (values.hasNext()) {
            DBObject object = values.next();
            String id = (String)object.get("mdId");
            String newId = null;
            if (id.contains("_")) {
                newId = StringUtils.substringBefore((String)id, (String)"_");
            }
            BasicDBObject input = new BasicDBObject();
            input.put("mdId", (Object)id);
            input.put("currentId", (Object)newId);
            input.put("expiring", (Object)new String[0]);
            input.put("transactions", (Object)new String[0]);
            this.getManagerTable().insert(new DBObject[]{input});
            log.debug((Object)String.format("Added %s to Metadata Manager data structure", id));
        }
        BasicDBObject ensureIndex = new BasicDBObject();
        ensureIndex.put("mdId", (Object)1);
        log.debug((Object)"Create index in MetadaManager ");
        this.getManagerTable().ensureIndex((DBObject)ensureIndex);
    }

    public void verifyConsistency() throws MDStoreServiceException {
        if (this.getManagerTable() == null) {
            if (!this.db.collectionExists(TABLE_NAME)) {
                this.bootstrapManager();
                if (this.getManagerTable() == null) {
                    throw new MDStoreServiceException("Something bad happen, unable to create managerTable");
                }
            } else {
                this.setManagerTable(this.db.getCollection(TABLE_NAME));
            }
        }
    }

    public void createMDStore(String mdId) throws MDStoreServiceException {
        log.debug((Object)"Creating new mdstore");
        this.verifyConsistency();
        String newId = mdId;
        if (mdId.contains("_")) {
            newId = StringUtils.substringBefore((String)mdId, (String)"_");
        }
        BasicDBObject instance = new BasicDBObject();
        instance.put("mdId", (Object)mdId);
        instance.put("currentId", (Object)newId);
        instance.put("expiring", (Object)new String[0]);
        this.getManagerTable().insert(new DBObject[]{instance});
        this.getManagerTable().save((DBObject)instance);
    }

    public void dropMDStore(String mdId) throws MDStoreServiceException {
        this.verifyConsistency();
        log.debug((Object)("Droping MDStore: " + mdId));
        BasicDBObject query = new BasicDBObject();
        query.put("mdId", (Object)mdId);
        DBCursor cursor = this.getManagerTable().find((DBObject)query);
        if (!cursor.hasNext()) {
            return;
        }
        DBObject item = cursor.next();
        this.garbage();
        this.db.getCollection((String)item.get("currentId")).drop();
        this.getManagerTable().remove((DBObject)query);
    }

    public String getMDStoreCollection(String mdId) throws MDStoreServiceException {
        this.verifyConsistency();
        BasicDBObject query = new BasicDBObject();
        query.put("mdId", (Object)mdId);
        DBCursor cursor = this.getManagerTable().find((DBObject)query);
        if (!cursor.hasNext()) {
            log.error((Object)("Error, unable to find Mdstore with Id " + mdId));
            throw new DocumentNotFoundException("Error, unable to find Mdstore with Id " + mdId);
        }
        return (String)cursor.next().get("currentId");
    }

    public String startTransaction(String mdId, boolean refresh) throws MDStoreServiceException {
        BasicDBList values;
        this.verifyConsistency();
        log.info((Object)("Start transaction for metadata store " + mdId));
        BasicDBObject query = new BasicDBObject();
        query.put("mdId", (Object)mdId);
        DBCursor cursor = this.getManagerTable().find((DBObject)query);
        if (!cursor.hasNext()) {
            throw new DocumentNotFoundException("Error, unable to find Mdstore with Id " + mdId);
        }
        String idCreation = StringUtils.substringBefore((String)mdId, (String)"_");
        long data = System.currentTimeMillis();
        idCreation = idCreation + "::" + data;
        DBObject object = cursor.next();
        BasicDBObject transactionMetadata = new BasicDBObject();
        transactionMetadata.put("id", (Object)idCreation.toString());
        transactionMetadata.put("refresh", (Object)refresh);
        transactionMetadata.put("date", (Object)new Date());
        if (object.containsField("transactions")) {
            values = (BasicDBList)object.get("transactions");
        } else {
            values = new BasicDBList();
            object.put("transactions", (Object)values);
        }
        values.add((Object)transactionMetadata);
        this.getManagerTable().save(object);
        return idCreation.toString();
    }

    public boolean commit(final String transactionId, String mdId) throws MDStoreServiceException {
        this.verifyConsistency();
        BasicDBObject query = new BasicDBObject();
        query.put("mdId", (Object)mdId);
        DBCursor cursor = this.getManagerTable().find((DBObject)query);
        if (!cursor.hasNext()) {
            throw new DocumentNotFoundException("Error, unable to find Mdstore with Id " + mdId);
        }
        DBObject object = cursor.next();
        BasicDBList transactions = (BasicDBList)object.get("transactions");
        DBObject transaction = this.findTransaction(transactions, transactionId);
        if (transaction == null) {
            throw new DocumentNotFoundException("Error, unable to find transaction with Id " + transactionId);
        }
        boolean refresh = (Boolean)transaction.get("refresh");
        transactions.remove((Object)transaction);
        String oldId = (String)object.get("currentId");
        if (refresh) {
            object.put("currentId", (Object)transactionId);
            BasicDBList stillUsed = (BasicDBList)object.get("expiring");
            if (stillUsed.size() == 0) {
                this.db.getCollection(oldId).drop();
            }
            log.debug((Object)"Replaced collection ");
        } else {
            MDStore currentMDStore = this.mdstoreDao.getMDStore(oldId);
            log.debug((Object)"commit incremental ");
            currentMDStore.feed((Iterable)new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new IncrementalIerator(MDStoreTransactionManagerImpl.this.db.getCollection(transactionId));
                }
            }, true);
        }
        this.managerTable.save(object);
        log.info((Object)("Committed transaction for metadata store " + mdId));
        return true;
    }

    private DBObject findTransaction(BasicDBList transactions, String transactionId) {
        if (transactions.size() == 0) {
            return null;
        }
        for (int i = 0; i < transactions.size(); ++i) {
            BasicDBObject transaction = (BasicDBObject)transactions.get(i);
            String id = (String)transaction.get("id");
            if (!transactionId.equals(id)) continue;
            return transaction;
        }
        return null;
    }

    public DB getDb() {
        return this.db;
    }

    @Required
    public void setDb(DB db) {
        this.db = db;
    }

    public String readMdStore(String mdStoreId) throws MDStoreServiceException {
        this.verifyConsistency();
        BasicDBObject query = new BasicDBObject();
        query.put("mdId", (Object)mdStoreId);
        DBCursor cursor = this.getManagerTable().find((DBObject)query);
        if (!cursor.hasNext()) {
            throw new DocumentNotFoundException("Error, unable to find Mdstore with Id " + mdStoreId);
        }
        DBObject object = cursor.next();
        String currentId = (String)object.get("currentId");
        BasicDBList values = (BasicDBList)object.get("expiring");
        this.updateMdstoreUsed(values, currentId);
        this.getManagerTable().save(object);
        return currentId;
    }

    private void updateMdstoreUsed(BasicDBList values, String mdId) {
        if (values.size() > 0) {
            for (int i = 0; i < values.size(); ++i) {
                DBObject obj = (DBObject)values.get(i);
                String id = (String)obj.get("id");
                if (!mdId.equals(id)) continue;
                obj.put("lastRead", (Object)new Date());
                return;
            }
        }
        BasicDBObject readStore = new BasicDBObject();
        readStore.put("id", (Object)mdId);
        readStore.put("lastRead", (Object)new Date());
        values.add((Object)readStore);
    }

    public DBCollection getManagerTable() {
        return this.managerTable;
    }

    public void setManagerTable(DBCollection managerTable) {
        this.managerTable = managerTable;
    }

    public MDStoreManagerInfo getInfoForCurrentMdStore(String mdStoreId) throws MDStoreServiceException {
        this.verifyConsistency();
        BasicDBObject query = new BasicDBObject();
        query.put("mdId", (Object)mdStoreId);
        DBCursor cursor = this.getManagerTable().find((DBObject)query);
        if (!cursor.hasNext()) {
            throw new DocumentNotFoundException("Error, unable to find Mdstore with Id " + mdStoreId);
        }
        DBObject object = cursor.next();
        MDStoreManagerInfo result = new MDStoreManagerInfo();
        result.setCurrentId((String)object.get("currentId"));
        result.setMdId((String)object.get("mdId"));
        BasicDBList values = (BasicDBList)object.get("expiring");
        for (int i = 0; i < values.size(); ++i) {
            MDStoreExpiredInfo stillused = new MDStoreExpiredInfo();
            DBObject value = (DBObject)values.get(i);
            stillused.setId((String)value.get("id"));
            stillused.setLastRead((Date)value.get("lastRead"));
            result.addExpiredItem(stillused);
        }
        BasicDBList transactions = (BasicDBList)object.get("transactions");
        if (transactions != null) {
            for (int i = 0; i < transactions.size(); ++i) {
                MDStoreTransactionInfo transaction = new MDStoreTransactionInfo();
                DBObject value = (DBObject)transactions.get(i);
                String transactionId = (String)value.get("id");
                transaction.setId(transactionId);
                transaction.setDate((Date)value.get("date"));
                transaction.setRefresh((Boolean)value.get("refresh"));
                transaction.setSize(this.db.getCollection(transactionId).count());
                result.addTransactionInfo(transaction);
            }
        }
        return result;
    }

    public Boolean dropUsed(String mdId, String idToDrop) throws MDStoreServiceException {
        this.verifyConsistency();
        BasicDBObject query = new BasicDBObject();
        query.put("mdId", (Object)mdId);
        DBCursor cursor = this.getManagerTable().find((DBObject)query);
        if (!cursor.hasNext()) {
            throw new DocumentNotFoundException("Error, unable to find Mdstore with Id " + mdId);
        }
        DBObject object = cursor.next();
        BasicDBList values = (BasicDBList)object.get("expiring");
        for (int i = 0; i < values.size(); ++i) {
            DBObject value = (DBObject)values.get(i);
            String currentUsedId = (String)value.get("id");
            if (!currentUsedId.equals(idToDrop)) continue;
            this.db.getCollection(idToDrop).drop();
            values.remove((Object)value);
            this.managerTable.save(object);
            return true;
        }
        throw new DocumentNotFoundException("Error, unable to drop old collection " + idToDrop);
    }

    public void garbage() throws MDStoreServiceException {
        this.verifyConsistency();
        log.info((Object)"Start garbage collection of MdStore");
        DBCursor cursor = this.managerTable.find();
        while (cursor.hasNext()) {
            DBObject currentObject = cursor.next();
            BasicDBList values = (BasicDBList)currentObject.get("expiring");
            String currentId = (String)currentObject.get("currentId");
            ArrayList<DBObject> toRemove = new ArrayList<DBObject>();
            for (int i = 0; i < values.size(); ++i) {
                DateTime today;
                DBObject value = (DBObject)values.get(i);
                String currentUsedId = (String)value.get("id");
                Date lastRead = (Date)value.get("lastRead");
                DateTime last = new DateTime((Object)lastRead);
                Days d = Days.daysBetween((ReadableInstant)last, (ReadableInstant)(today = new DateTime()));
                if (d.getDays() <= this.getExpiredDays()) continue;
                if (!currentUsedId.equals(currentId)) {
                    this.db.getCollection(currentUsedId).drop();
                    log.debug((Object)("delete collection " + currentUsedId));
                }
                toRemove.add(value);
            }
            for (DBObject obj : toRemove) {
                values.remove((Object)obj);
            }
            this.managerTable.save(currentObject);
        }
        log.info((Object)"Complete garbage collection  of MdStore");
    }

    public int getExpiredDays() {
        if (this.expiredDays == 0) {
            return 3;
        }
        return this.expiredDays;
    }

    public void setExpiredDays(int expiredDays) {
        this.expiredDays = expiredDays;
    }

    public MDStoreDao getMdstoreDao() {
        return this.mdstoreDao;
    }

    public void setMdstoreDao(MDStoreDao mdstoreDao) {
        this.mdstoreDao = mdstoreDao;
    }

    public Boolean dropTransaction(String mdId, String idToDrop) throws MDStoreServiceException {
        this.verifyConsistency();
        BasicDBObject query = new BasicDBObject();
        query.put("mdId", (Object)mdId);
        DBCursor cursor = this.getManagerTable().find((DBObject)query);
        if (!cursor.hasNext()) {
            throw new DocumentNotFoundException("Error, unable to find Mdstore with Id " + mdId);
        }
        DBObject object = cursor.next();
        BasicDBList values = (BasicDBList)object.get("transactions");
        for (int i = 0; i < values.size(); ++i) {
            DBObject value = (DBObject)values.get(i);
            String currentUsedId = (String)value.get("id");
            if (!currentUsedId.equals(idToDrop)) continue;
            this.db.getCollection(idToDrop).drop();
            values.remove((Object)value);
            this.managerTable.save(object);
            return true;
        }
        throw new DocumentNotFoundException("Error, unable to drop old collection " + idToDrop);
    }
}

